/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.data;

import com.jarhax.prestige.Prestige;
import com.jarhax.prestige.api.Reward;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.darkhax.bookshelf.util.NBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class PlayerData {
    private static final String TAG_OWNER = "PlayerId";
    private static final String TAG_CONFIRMED = "Prestige";
    private static final String TAG_UNLOCKED = "Unlocked";
    private static final String TAG_SOURCES = "Sources";
    private static final String TAG_LAST_RESPEC = "respecTimer";
    private UUID playerId;
    private long prestige;
    private final Set<Reward> unlockedRewards;
    private final Set<String> sources;
    private long respTimer;

    public PlayerData(EntityPlayer player) {
        this(player.getPersistentID());
    }

    public PlayerData(UUID id) {
        this.playerId = id;
        this.prestige = 0L;
        this.unlockedRewards = new HashSet<Reward>();
        this.sources = new HashSet<String>();
        this.respTimer = 0L;
    }

    public PlayerData(NBTTagCompound tag) {
        this.playerId = tag.func_186857_a(TAG_OWNER);
        this.prestige = tag.func_74763_f(TAG_CONFIRMED);
        this.unlockedRewards = (Set)NBTUtils.readCollection(new HashSet(), (NBTTagList)tag.func_150295_c(TAG_UNLOCKED, 8), Prestige.REGISTRY::get);
        this.sources = (Set)NBTUtils.readCollection(new HashSet(), (NBTTagList)tag.func_150295_c(TAG_SOURCES, 8), string -> string);
        this.respTimer = tag.func_74763_f(TAG_LAST_RESPEC);
    }

    public NBTTagCompound save() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a(TAG_OWNER, this.playerId);
        tag.func_74772_a(TAG_CONFIRMED, this.prestige);
        NBTTagList tagList = new NBTTagList();
        for (Reward reward : this.unlockedRewards) {
            if (reward == null) continue;
            tagList.func_74742_a((NBTBase)new NBTTagString(reward.getIdentifier()));
        }
        tag.func_74782_a(TAG_UNLOCKED, (NBTBase)tagList);
        tag.func_74782_a(TAG_SOURCES, (NBTBase)NBTUtils.writeCollection(this.sources, string -> string));
        tag.func_74772_a(TAG_LAST_RESPEC, this.respTimer);
        return tag;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public long getPrestige() {
        return this.prestige;
    }

    public void setPrestige(long confirmed) {
        this.prestige = confirmed;
    }

    public void addPrestige(long amount) {
        this.prestige += amount;
    }

    public void removePrestige(long amount) {
        this.prestige -= amount;
    }

    public Set<Reward> getUnlockedRewards() {
        return this.unlockedRewards;
    }

    public void unlockReward(Reward reward) {
        this.getUnlockedRewards().add(reward);
    }

    public void removeReward(Reward reward) {
        this.getUnlockedRewards().remove(reward);
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public boolean hasSource(String source) {
        return this.getSources().contains(source);
    }

    public void addSource(String source) {
        this.getSources().add(source);
    }

    public void removeSource(String source) {
        this.getSources().remove(source);
    }

    public String getFileName() {
        return this.playerId.toString() + ".dat";
    }

    public boolean hasReward(Reward reward) {
        return this.getUnlockedRewards().contains(reward);
    }

    public boolean canPurchase(Reward reward) {
        return reward != null && this.prestige >= (long)reward.getCost() && !this.hasReward(reward) && this.hasRequiredRewards(reward);
    }

    public boolean hasRequiredRewards(Reward reward) {
        for (Reward parent : reward.getParents()) {
            if (this.hasReward(parent)) continue;
            return false;
        }
        return true;
    }

    public long getRespTimer() {
        return this.respTimer;
    }

    public void setRespTimer(long respTimer) {
        this.respTimer = respTimer;
    }
}

