/*
 * Decompiled with CFR 0.152.
 */
package bouncy_creepers;

import bouncy_creepers.configs.ConfigHandler;
import bouncy_creepers.entities.EntityBouncyCreeper;
import bouncy_creepers.proxy.CommonProxy;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod(modid="bouncy_creepers", name="bouncy_creepers", version="0.0.4", guiFactory="bouncy_creepers.configs.ConfigGuiFactory", dependencies="after:biomesoplenty", acceptedMinecraftVersions="[1.12.2]")
public class BouncyCreepers {
    @Mod.Instance(value="bouncy_creepers")
    public static BouncyCreepers INSTANCE;
    @SidedProxy(clientSide="bouncy_creepers.proxy.ClientProxy", serverSide="bouncy_creepers.proxy.CommonProxy")
    public static CommonProxy PROXY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.loadConfig(event);
        EntityRegistry.registerModEntity((ResourceLocation)BouncyCreepers.getEntityResource("bouncy_creeper"), EntityBouncyCreeper.class, (String)"bouncy_creepers.bouncy_creeper", (int)1, (Object)this, (int)120, (int)1, (boolean)true, (int)894731, (int)0);
        EntitySpawnPlacementRegistry.setPlacementType(EntityBouncyCreeper.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        PROXY.registerRenderers();
        for (Biome allBiomes : ForgeRegistries.BIOMES.getValuesCollection()) {
            if (BiomeDictionary.hasType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || ConfigHandler.BOUNCY_CREEPER_SPAWN_PROBABILITY <= 0 || ConfigHandler.BOUNCY_CREEPER_MIN_SPAWN_SIZE <= 0 || ConfigHandler.BOUNCY_CREEPER_MAX_SPAWN_SIZE <= 0) continue;
            EntityRegistry.addSpawn(EntityBouncyCreeper.class, (int)ConfigHandler.BOUNCY_CREEPER_SPAWN_PROBABILITY, (int)ConfigHandler.BOUNCY_CREEPER_MIN_SPAWN_SIZE, (int)ConfigHandler.BOUNCY_CREEPER_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
        }
    }

    private static ResourceLocation getEntityResource(String entityName) {
        return new ResourceLocation("bouncy_creepers", entityName);
    }

    @Mod.EventHandler
    public void posInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)ConfigHandler.INSTANCE);
    }
}

