/*
 * Decompiled with CFR 0.152.
 */
package bouncy_creepers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModSounds {
    public static final List<SoundEvent> SOUNDS = new ArrayList<SoundEvent>();
    public static final SoundEvent BOUNCY_CREEPER_BOING = ModSounds.registerSoundResource("BOUNCY_CREEPER_BOING");
    public static final SoundEvent BOUNCY_CREEPER_DEATH = ModSounds.registerSoundResource("BOUNCY_CREEPER_DEATH");
    public static final SoundEvent BOUNCY_CREEPER_HURT = ModSounds.registerSoundResource("BOUNCY_CREEPER_HURT");
    public static final SoundEvent BOUNCY_CREEPER_INFLATE = ModSounds.registerSoundResource("BOUNCY_CREEPER_INFLATE");
    public static final SoundEvent BOUNCY_CREEPER_POPPING = ModSounds.registerSoundResource("BOUNCY_CREEPER_POPPING");

    public static SoundEvent registerSoundResource(String name) {
        return new SoundEvent(new ResourceLocation("bouncy_creepers", name));
    }

    public static void init() {
        try {
            for (Field field : ModSounds.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                SoundEvent sound = (SoundEvent)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModSounds.registerSoundName(name, sound);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSoundName(String name, SoundEvent sound) {
        SOUNDS.add(sound);
        sound.setRegistryName("bouncy_creepers", name.toLowerCase(Locale.ENGLISH));
    }

    @Mod.EventBusSubscriber(modid="bouncy_creepers")
    public static class RegistrationHandlerSounds {
        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            ModSounds.init();
            IForgeRegistry registry = event.getRegistry();
            for (SoundEvent sounds : SOUNDS) {
                registry.register((IForgeRegistryEntry)sounds);
            }
        }
    }
}

