/*
 * Decompiled with CFR 0.152.
 */
package bouncy_creepers.client;

import bouncy_creepers.client.LayerBouncyCreeperCharge;
import bouncy_creepers.entities.EntityBouncyCreeper;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBouncyCreeper
extends RenderLiving<EntityBouncyCreeper> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/creeper/creeper.png");

    public RenderBouncyCreeper(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)new ModelCreeper(), 1.0f);
        this.func_177094_a(new LayerBouncyCreeperCharge(this));
    }

    protected void preRenderCallback(EntityBouncyCreeper creeper, float partialTickTime) {
        boolean i = true;
        float f1 = (creeper.prevSquishFactor + (creeper.squishFactor - creeper.prevSquishFactor) * partialTickTime) / ((float)i * 0.5f + 1.0f);
        float f2 = 1.0f / (f1 + 1.0f);
        float f3 = (float)i;
        GlStateManager.func_179152_a((float)(f2 * f3), (float)(1.0f / f2 * f3), (float)(f2 * f3));
        float g = creeper.getCreeperFlashIntensity(partialTickTime);
        float g1 = 1.0f + MathHelper.func_76126_a((float)(g * 100.0f)) * g * 0.01f;
        g = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        g *= g;
        g *= g;
        float g2 = (1.0f + g * 0.4f) * g1;
        float g3 = (1.0f + g * 0.1f) / g1;
        GlStateManager.func_179152_a((float)g2, (float)g3, (float)g2);
    }

    protected int getColorMultiplier(EntityBouncyCreeper creeper, float lightBrightness, float partialTickTime) {
        float f = creeper.getCreeperFlashIntensity(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }

    protected ResourceLocation getEntityTexture(EntityBouncyCreeper creeper) {
        return TEXTURE;
    }
}

