/*
 * Decompiled with CFR 0.152.
 */
package bouncy_creepers.configs;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration CONFIG;
    public static int BOUNCY_CREEPER_MIN_SPAWN_SIZE;
    public static int BOUNCY_CREEPER_MAX_SPAWN_SIZE;
    public static int BOUNCY_CREEPER_SPAWN_PROBABILITY;
    public static String[] BOUNCY_CREEPER_BLACKLISTED_DIMS;
    public static boolean BOUNCY_CREEPER_BOING_SOUND;
    public static float BOUNCY_CREEPER_EXPLOSION_RADIUS;
    public static int BOUNCY_CREEPER_EXPLOSION_LINGER;
    public static int BOUNCY_CREEPER_EXPLOSION_NAUSIA;
    public static int BOUNCY_CREEPER_EXPLOSION_LEVITATION;
    public static float BOUNCY_CREEPER_CHARGED_EXPLOSION_RADIUS;
    public static int BOUNCY_CREEPER_CHARGED_EXPLOSION_LINGER;
    public static int BOUNCY_CREEPER_CHARGED_EXPLOSION_NAUSIA;
    public static int BOUNCY_CREEPER_CHARGED_EXPLOSION_LEVITATION;
    public final String[] usedCategories = new String[]{"Settings"};

    public void loadConfig(FMLPreInitializationEvent event) {
        this.CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        this.CONFIG.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        BOUNCY_CREEPER_MIN_SPAWN_SIZE = this.CONFIG.get("Settings", "Spawn Group Minimum Size", 1).getInt(1);
        BOUNCY_CREEPER_MAX_SPAWN_SIZE = this.CONFIG.get("Settings", "Spawn Group Maximum Size", 4).getInt(4);
        BOUNCY_CREEPER_SPAWN_PROBABILITY = this.CONFIG.get("Settings", "Spawn Chance Probability", 100).getInt(100);
        BOUNCY_CREEPER_BLACKLISTED_DIMS = this.CONFIG.getStringList("Bouncy Creeper Spawn Dimension Blacklist", "Settings", new String[]{"1", "-1"}, "");
        BOUNCY_CREEPER_BOING_SOUND = this.CONFIG.get("Settings", "Bouncy Creepers Jump Sound", true).getBoolean(true);
        BOUNCY_CREEPER_EXPLOSION_RADIUS = this.CONFIG.getFloat("Explosion Size", "Settings", 2.5f, 1.0f, 32.0f, "");
        BOUNCY_CREEPER_EXPLOSION_LINGER = this.CONFIG.get("Settings", "Explosion Shrink", 600).getInt(600);
        BOUNCY_CREEPER_EXPLOSION_NAUSIA = this.CONFIG.get("Settings", "Explosion Nausia Duration", 200).getInt(200);
        BOUNCY_CREEPER_EXPLOSION_LEVITATION = this.CONFIG.get("Settings", "Explosion Levitation Duration", 140).getInt(140);
        BOUNCY_CREEPER_CHARGED_EXPLOSION_RADIUS = this.CONFIG.getFloat("Charged Explosion Size", "Settings", 5.0f, 1.0f, 32.0f, "");
        BOUNCY_CREEPER_CHARGED_EXPLOSION_LINGER = this.CONFIG.get("Settings", "Charged Explosion Shrink", 600).getInt(600);
        BOUNCY_CREEPER_CHARGED_EXPLOSION_NAUSIA = this.CONFIG.get("Settings", "Charged Explosion Nausia Duration", 400).getInt(400);
        BOUNCY_CREEPER_CHARGED_EXPLOSION_LEVITATION = this.CONFIG.get("Settings", "Charged Explosion Levitation Duration", 280).getInt(280);
        if (this.CONFIG.hasChanged()) {
            this.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("bouncy_creepers")) {
            this.syncConfigs();
        }
    }
}

