/*
 * Decompiled with CFR 0.152.
 */
package bouncy_creepers.entities;

import bouncy_creepers.BouncyCreepers;
import bouncy_creepers.ModSounds;
import bouncy_creepers.ai.EntityAIBouncyCreeperSwell;
import bouncy_creepers.configs.ConfigHandler;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBouncyCreeper
extends EntityMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityBouncyCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityBouncyCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityBouncyCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;
    private EntityAIBouncyCreeperSwell aiCreeperSwell;

    public EntityBouncyCreeper(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.6f, 1.7f);
        this.field_70765_h = new BouncyCreeperMoveHelper(this);
    }

    protected void func_184651_r() {
        this.aiCreeperSwell = new EntityAIBouncyCreeperSwell(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIBouncyCreeperFloat(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiCreeperSwell);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBouncyCreeperAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIBouncyCreeperFaceRandom(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIBouncyCreeperHop(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public int getMaxSafePointTries() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        if (this.func_70089_S() && this.func_184187_bx() == null) {
            this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
            if (this.timeSinceIgnited > this.fuseTime - 5) {
                this.timeSinceIgnited = this.fuseTime - 5;
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("wasOnGround", this.wasOnGround);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            nbt.func_74757_a("powered", true);
        }
        nbt.func_74777_a("Fuse", (short)this.fuseTime);
        nbt.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        nbt.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.wasOnGround = nbt.func_74767_n("wasOnGround");
        this.field_70180_af.func_187227_b(POWERED, (Object)nbt.func_74767_n("powered"));
        if (nbt.func_150297_b("Fuse", 99)) {
            this.fuseTime = nbt.func_74765_d("Fuse");
        }
        if (nbt.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.func_74771_c("ExplosionRadius");
        }
        if (nbt.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean func_70601_bi() {
        if (this.isDimBlacklisted(this.field_71093_bK).booleanValue()) {
            return false;
        }
        return super.func_70601_bi();
    }

    private Boolean isDimBlacklisted(int dimensionIn) {
        ArrayList<Integer> dimBlackList = new ArrayList<Integer>();
        for (int dims = 0; dims < ConfigHandler.BOUNCY_CREEPER_BLACKLISTED_DIMS.length; ++dims) {
            String dimEntry = ConfigHandler.BOUNCY_CREEPER_BLACKLISTED_DIMS[dims].trim();
            dimBlackList.add(Integer.valueOf(dimEntry));
        }
        if (dimBlackList.contains(dimensionIn)) {
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.func_130014_f_().func_82736_K().func_82766_b("doMobLoot")) {
            if (cause.func_76346_g() instanceof EntitySkeleton) {
                int i = Item.func_150891_b((Item)Items.field_151096_cd);
                int j = Item.func_150891_b((Item)Items.field_151084_co);
                int k = i + this.field_70146_Z.nextInt(j - i + 1);
                this.func_145779_a(Item.func_150899_d((int)k), 1);
            } else if (cause.func_76346_g() instanceof EntityBouncyCreeper && cause.func_76346_g() != this && ((EntityBouncyCreeper)cause.func_76346_g()).getPowered() && ((EntityBouncyCreeper)cause.func_76346_g()).isAIEnabled()) {
                ((EntityBouncyCreeper)cause.func_76346_g()).incrementDroppedSkulls();
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186434_p;
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        if (this.func_70089_S() && this.func_184187_bx() == null) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(ModSounds.BOUNCY_CREEPER_INFLATE, 2.0f, 1.0f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            for (int j = 0; j < 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
                if (!this.func_130014_f_().field_72995_K) continue;
                BouncyCreepers.PROXY.spawnCustomParticle("boing", this.func_130014_f_(), this.field_70165_t + (double)f2, this.func_180425_c().func_177956_o(), this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -1.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 2.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float renderTick) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * renderTick) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151033_d) {
            this.func_130014_f_().func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.func_130014_f_().field_72995_K) {
                this.ignite();
                stack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    private void explode() {
        if (!this.func_130014_f_().field_72995_K) {
            boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.func_130014_f_(), (Entity)this);
            float explosionRadius = this.getPowered() ? ConfigHandler.BOUNCY_CREEPER_CHARGED_EXPLOSION_RADIUS : ConfigHandler.BOUNCY_CREEPER_EXPLOSION_RADIUS;
            int explosionDuration = this.getPowered() ? ConfigHandler.BOUNCY_CREEPER_CHARGED_EXPLOSION_LINGER : ConfigHandler.BOUNCY_CREEPER_EXPLOSION_LINGER;
            int levitation = this.getPowered() ? ConfigHandler.BOUNCY_CREEPER_CHARGED_EXPLOSION_LEVITATION : ConfigHandler.BOUNCY_CREEPER_EXPLOSION_LEVITATION;
            int nausia = this.getPowered() ? ConfigHandler.BOUNCY_CREEPER_CHARGED_EXPLOSION_NAUSIA : ConfigHandler.BOUNCY_CREEPER_EXPLOSION_NAUSIA;
            this.field_70729_aU = true;
            this.func_184185_a(ModSounds.BOUNCY_CREEPER_POPPING, 2.0f, 0.5f);
            this.func_70106_y();
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(explosionRadius);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(explosionDuration);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            if (levitation > 0) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_188424_y, levitation));
            }
            if (nausia > 0) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76431_k, nausia));
            }
            this.func_130014_f_().func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public boolean isAIEnabled() {
        return this.droppedSkulls < 1 && this.func_130014_f_().func_82736_K().func_82766_b("doMobLoot");
    }

    public void incrementDroppedSkulls() {
        ++this.droppedSkulls;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.BOUNCY_CREEPER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.BOUNCY_CREEPER_DEATH;
    }

    protected SoundEvent getSquishSound() {
        return ModSounds.BOUNCY_CREEPER_HURT;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.5;
        this.field_70160_al = true;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected SoundEvent getJumpSound() {
        return ModSounds.BOUNCY_CREEPER_BOING;
    }

    static class BouncyCreeperMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntityBouncyCreeper bouncy_creeper;
        private boolean isAggressive;

        public BouncyCreeperMoveHelper(EntityBouncyCreeper creeper) {
            super((EntityLiving)creeper);
            this.bouncy_creeper = creeper;
            this.yRot = 180.0f * creeper.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float rotationY, boolean aggressive) {
            this.yRot = rotationY;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.bouncy_creeper.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.bouncy_creeper.func_70683_ar().func_75660_a();
                        if (ConfigHandler.BOUNCY_CREEPER_BOING_SOUND) {
                            this.bouncy_creeper.func_130014_f_().func_184133_a(null, this.bouncy_creeper.func_180425_c(), this.bouncy_creeper.getJumpSound(), SoundCategory.HOSTILE, 1.0f, (this.bouncy_creeper.func_70681_au().nextFloat() - this.bouncy_creeper.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                        }
                    } else {
                        this.bouncy_creeper.field_70702_br = 0.0f;
                        this.bouncy_creeper.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AIBouncyCreeperHop
    extends EntityAIBase {
        private final EntityBouncyCreeper bouncy_creeper;

        public AIBouncyCreeperHop(EntityBouncyCreeper creeper) {
            this.bouncy_creeper = creeper;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((BouncyCreeperMoveHelper)this.bouncy_creeper.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AIBouncyCreeperFloat
    extends EntityAIBase {
        private final EntityBouncyCreeper bouncy_creeper;

        public AIBouncyCreeperFloat(EntityBouncyCreeper creeper) {
            this.bouncy_creeper = creeper;
            this.func_75248_a(5);
            ((PathNavigateGround)creeper.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.bouncy_creeper.func_70090_H() || this.bouncy_creeper.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.bouncy_creeper.func_70681_au().nextFloat() < 0.8f) {
                this.bouncy_creeper.func_70683_ar().func_75660_a();
            }
            ((BouncyCreeperMoveHelper)this.bouncy_creeper.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AIBouncyCreeperFaceRandom
    extends EntityAIBase {
        private final EntityBouncyCreeper bouncy_creeper;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AIBouncyCreeperFaceRandom(EntityBouncyCreeper creeper) {
            this.bouncy_creeper = creeper;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.bouncy_creeper.func_70638_az() == null && (this.bouncy_creeper.field_70122_E || this.bouncy_creeper.func_70090_H() || this.bouncy_creeper.func_180799_ab() || this.bouncy_creeper.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.bouncy_creeper.func_70681_au().nextInt(60);
                this.chosenDegrees = this.bouncy_creeper.func_70681_au().nextInt(360);
            }
            ((BouncyCreeperMoveHelper)this.bouncy_creeper.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AIBouncyCreeperAttack
    extends EntityAIBase {
        private final EntityBouncyCreeper bouncy_creeper;
        private int growTieredTimer;

        public AIBouncyCreeperAttack(EntityBouncyCreeper creeper) {
            this.bouncy_creeper = creeper;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.bouncy_creeper.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.bouncy_creeper.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.bouncy_creeper.func_70625_a((Entity)this.bouncy_creeper.func_70638_az(), 10.0f, 10.0f);
            ((BouncyCreeperMoveHelper)this.bouncy_creeper.func_70605_aq()).setDirection(this.bouncy_creeper.field_70177_z, true);
        }
    }
}

