/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shadows.deadly.DeadlyLoot;
import shadows.deadly.config.DeadlyConfig;
import shadows.deadly.config.DeadlyConstants;
import shadows.deadly.gen.SpawnerItem;
import shadows.deadly.gen.WorldFeature;
import shadows.deadly.gen.WorldGenerator;
import shadows.util.ChestBuilder;
import shadows.util.TagBuilder;

public class BrutalSpawner
extends WorldFeature {
    public static final NBTTagCompound BASE_TAG = new NBTTagCompound();
    public static final List<SpawnerItem> BRUTAL_SPAWNERS = new ArrayList<SpawnerItem>();

    @Override
    public void generate(World world, int chunkX, int chunkZ, Random rand) {
        int y;
        if ((double)DeadlyConfig.brutalSpawnerChance <= rand.nextDouble()) {
            return;
        }
        int x = (chunkX << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        int z = (chunkZ << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, y, z);
        for (y = 15 + rand.nextInt(35); y > 10; --y) {
            if (!this.canBePlaced(world, (BlockPos)mPos.func_181079_c(x, y, z), rand)) continue;
            this.place(world, (BlockPos)mPos.func_181079_c(x, y, z), rand);
            WorldGenerator.setSuccess(world.field_73011_w.getDimension(), chunkX, chunkZ);
            return;
        }
    }

    @Override
    public boolean canBePlaced(World world, BlockPos pos, Random rand) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && WorldGenerator.STONE_TEST.apply((Object)world.func_180495_p(pos)) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a());
    }

    @Override
    public void place(World world, BlockPos pos, Random rand) {
        ((SpawnerItem)WeightedRandom.func_76271_a((Random)rand, BRUTAL_SPAWNERS)).place(world, pos);
        ChestBuilder.place(world, rand, pos.func_177977_b(), rand.nextInt(9) == 0 ? DeadlyLoot.CHEST_VALUABLE : DeadlyLoot.SPAWNER_BRUTAL);
        world.func_180501_a(pos.func_177984_a(), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), 2);
        for (EnumFacing f : EnumFacing.field_176754_o) {
            if (!world.func_180495_p(pos.func_177972_a(f)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177972_a(f))) continue;
            PropertyBool side = (PropertyBool)Blocks.field_150395_bd.func_176194_O().func_185920_a(f.func_176734_d().func_176610_l());
            world.func_175656_a(pos.func_177972_a(f), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)side, (Comparable)Boolean.valueOf(true)));
        }
        WorldGenerator.debugLog(pos, "Brutal Spawner");
    }

    @Override
    public boolean isEnabled() {
        return !BRUTAL_SPAWNERS.isEmpty() && DeadlyConfig.brutalSpawnerChance > 0.0f;
    }

    public static void init() {
        for (PotionEffect p : DeadlyConfig.BRUTAL_POTIONS) {
            TagBuilder.addPotionEffect(BASE_TAG, p.func_188419_a(), p.func_76458_c());
        }
        SpawnerItem.addItems(BRUTAL_SPAWNERS, DeadlyConstants.BRUTAL_SPAWNER_STATS, DeadlyConfig.BRUTAL_MOBS);
        for (SpawnerItem i : BRUTAL_SPAWNERS) {
            BrutalSpawner.initBrutal(i);
        }
    }

    public static void initBrutal(SpawnerItem item) {
        BrutalSpawner.applyBrutalStats(item.getSpawner().getSpawnData());
        for (NBTBase tag : item.getSpawner().getPotentials()) {
            BrutalSpawner.applyBrutalStats(BrutalSpawner.getOrCreate((NBTTagCompound)tag, "Entity"));
        }
    }

    public static NBTTagCompound applyBrutalStats(NBTTagCompound tag) {
        TagBuilder.checkForSkeleton(tag);
        for (String name : BASE_TAG.func_150296_c()) {
            tag.func_74782_a(name, BASE_TAG.func_74781_a(name).func_74737_b());
        }
        return TagBuilder.checkForCreeper(tag);
    }

    private static NBTTagCompound getOrCreate(NBTTagCompound parent, String key) {
        if (!parent.func_150297_b(key, 10)) {
            parent.func_74782_a(key, (NBTBase)new NBTTagCompound());
        }
        return parent.func_74775_l(key);
    }
}

