/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench.asm;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import shadows.ApotheosisCore;
import shadows.ApotheosisTransformer;
import shadows.CustomClassWriter;
import shadows.deadly.asm.DeadlyTransformer;

public class EnchTransformer
implements ApotheosisTransformer.IApotheosisTransformer {
    @Override
    public boolean accepts(String name, String transformedName) {
        return "net.minecraft.enchantment.EnchantmentHelper".equals(transformedName) || "net.minecraft.entity.ai.EntityAITempt".equals(transformedName) || "net.minecraft.item.Item".equals(transformedName) || "net.minecraft.entity.EntityLivingBase".equals(transformedName);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!ApotheosisCore.enableEnch) {
            return basicClass;
        }
        if ("net.minecraft.enchantment.EnchantmentHelper".equals(transformedName)) {
            return this.transformEnchHelper(basicClass);
        }
        if ("net.minecraft.item.Item".equals(transformedName)) {
            return this.transformItem(basicClass);
        }
        if ("net.minecraft.entity.EntityLivingBase".equals(transformedName)) {
            return this.transformELB(basicClass);
        }
        return this.transformAI(basicClass);
    }

    public byte[] transformEnchHelper(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming EnchantmentHelper...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode calcStackEnch = ApotheosisCore.findMethod(classNode, ApotheosisCore::isCalcStackEnch);
        MethodNode getEnchantmentDatas = ApotheosisCore.findMethod(classNode, ApotheosisCore::isEnchDatas);
        if (calcStackEnch != null) {
            JumpInsnNode jumpNode = null;
            for (int i = 0; i < calcStackEnch.instructions.size(); ++i) {
                AbstractInsnNode n = calcStackEnch.instructions.get(i);
                if (n.getOpcode() != 16 || ((IntInsnNode)n).operand != 15) continue;
                jumpNode = (JumpInsnNode)n.getNext();
                break;
            }
            if (jumpNode != null) {
                calcStackEnch.instructions.insert(jumpNode, (AbstractInsnNode)new JumpInsnNode(167, jumpNode.label));
                ApotheosisCore.LOG.info("Successfully transformed EnchantmentHelper.calcItemStackEnchantability");
            }
        }
        if (getEnchantmentDatas != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(21, 0));
            insn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insn.add((AbstractInsnNode)new VarInsnNode(21, 2));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/ench/asm/EnchHooks", "getEnchantmentDatas", "(ILnet/minecraft/item/ItemStack;Z)Ljava/util/List;", false));
            insn.add((AbstractInsnNode)new InsnNode(176));
            getEnchantmentDatas.instructions.insert(insn);
            ApotheosisCore.LOG.info("Successfully transformed EnchantmentHelper.getEnchantmentDatas");
        }
        ApotheosisCore.LOG.info("[Deadly] Transforming EnchantmentHelper...");
        DeadlyTransformer.transformEnchHelper(classNode);
        ApotheosisCore.LOG.info("[Deadly] Successfully transformed EnchantmentHelper");
        if (calcStackEnch != null && getEnchantmentDatas != null) {
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed EnchantmentHelper");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming EnchantmentHelper");
        return basicClass;
    }

    public byte[] transformAI(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming EntityAITempt...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode isTempting = null;
        for (MethodNode m : classNode.methods) {
            if (!ApotheosisCore.isTempting(m)) continue;
            isTempting = m;
            break;
        }
        if (isTempting != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/ench/asm/EnchHooks", "isTempting", "(ZLnet/minecraft/item/ItemStack;)Z", false));
            AbstractInsnNode node = isTempting.instructions.getLast().getPrevious();
            isTempting.instructions.insertBefore(node, insn);
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed EntityAITempt");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming EntityAITempt");
        return basicClass;
    }

    public byte[] transformItem(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming Item...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode getItemEnchantability = null;
        for (MethodNode m : classNode.methods) {
            if (!ApotheosisCore.isItemEnch(m)) continue;
            getItemEnchantability = m;
            break;
        }
        if (getItemEnchantability != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new LdcInsnNode((Object)10));
            insn.add((AbstractInsnNode)new InsnNode(172));
            getItemEnchantability.instructions.insert(insn);
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed Item");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming Item");
        return basicClass;
    }

    public byte[] transformELB(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming EntityLivingBase...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode blockUsingShield = null;
        for (MethodNode m : classNode.methods) {
            if (!ApotheosisCore.isBlockWithShield(m)) continue;
            blockUsingShield = m;
            break;
        }
        if (blockUsingShield != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/ench/asm/EnchHooks", "reflectiveHook", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/EntityLivingBase;)V", false));
            blockUsingShield.instructions.insert(insn);
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed EntityLivingBase");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming EntityLivingBase");
        return basicClass;
    }
}

