/*
 * Decompiled with CFR 0.152.
 */
package shadows.util;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import shadows.ApotheosisCore;
import shadows.ApotheosisTransformer;
import shadows.CustomClassWriter;

public class BedTransformer
implements ApotheosisTransformer.IApotheosisTransformer {
    @Override
    public boolean accepts(String name, String transformedName) {
        return transformedName.equals("net.minecraft.block.BlockBed");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming BlockBed...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode onBlockActivated = null;
        for (MethodNode m : classNode.methods) {
            if (!ApotheosisCore.isOnBlockActivated(m)) continue;
            onBlockActivated = m;
            break;
        }
        if (onBlockActivated != null) {
            for (int i = onBlockActivated.instructions.size() - 1; i >= 0; --i) {
                AbstractInsnNode n = onBlockActivated.instructions.get(i);
                if (n.getOpcode() != 1) continue;
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/Apotheosis", "fakesplode", "(Ljava/lang/Object;Ljava/lang/Object;)V", false));
                list.add((AbstractInsnNode)new InsnNode(4));
                list.add((AbstractInsnNode)new InsnNode(172));
                onBlockActivated.instructions.insertBefore(n, list);
                CustomClassWriter writer = new CustomClassWriter(3);
                classNode.accept((ClassVisitor)writer);
                ApotheosisCore.LOG.info("Successfully transformed BlockBed");
                return writer.toByteArray();
            }
        }
        ApotheosisCore.LOG.info("Failed transforming BlockBed");
        return basicClass;
    }
}

