/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.item.ItemPistonWand;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketMoveBlock
implements IMessage,
IMessageHandler<PacketMoveBlock, IMessage> {
    private BlockPos pos;
    private ItemPistonWand.ActionType type;
    private EnumFacing side;

    public PacketMoveBlock() {
    }

    public PacketMoveBlock(BlockPos mouseover, ItemPistonWand.ActionType t, EnumFacing s) {
        this.pos = mouseover;
        this.type = t;
        this.side = s;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        int t = tags.func_74762_e("t");
        this.type = ItemPistonWand.ActionType.values()[t];
        int s = tags.func_74762_e("s");
        this.side = EnumFacing.values()[s];
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("t", this.type.ordinal());
        tags.func_74768_a("s", this.side.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(final PacketMoveBlock message, final MessageContext ctx) {
        MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (s == null) {
            this.handle(message, ctx);
        } else {
            s.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketMoveBlock.this.handle(message, ctx);
                }
            });
        }
        return null;
    }

    private void handle(PacketMoveBlock message, MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World worldObj = player.func_130014_f_();
            BlockPos resultPosition = null;
            switch (message.type) {
                case PULL: {
                    resultPosition = UtilPlaceBlocks.pullBlock(worldObj, (EntityPlayer)player, message.pos, message.side);
                    break;
                }
                case PUSH: {
                    resultPosition = UtilPlaceBlocks.pushBlock(worldObj, (EntityPlayer)player, message.pos, message.side);
                    break;
                }
                case ROTATE: {
                    UtilPlaceBlocks.rotateBlockValidState(worldObj, (EntityPlayer)player, message.pos, message.side);
                    resultPosition = this.pos;
                    break;
                }
            }
        }
    }
}

