/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.blocks;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.gory_moon.chargers.ChargersMod;
import se.gory_moon.chargers.blocks.BlockCharger;
import se.gory_moon.chargers.blocks.BlockWirelessCharger;

@Mod.EventBusSubscriber(modid="chargers")
public class BlockRegistry {
    public static final Block CHARGER = new BlockCharger();
    public static final Block WIRELESS_CHARGER = new BlockWirelessCharger();
    public static final Set<Block> BLOCKS = new LinkedHashSet<Block>();
    public static final List<ItemBlock> ITEM_BLOCKS = new ArrayList<ItemBlock>();

    public static void preInit() {
        try {
            for (Field field : BlockRegistry.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof Block)) continue;
                Block block = (Block)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                BlockRegistry.registerBlock(name, block);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerBlock(String name, Block block) {
        BLOCKS.add(block);
        ((Block)block.setRegistryName("chargers", name)).func_149663_c("chargers." + name);
        ItemBlock item = block instanceof ICustomItemBlock ? ((ICustomItemBlock)block).getItemBlock() : new ItemBlock(block);
        ITEM_BLOCKS.add(item);
        ((Item)item.setRegistryName("chargers", name)).func_77655_b("chargers." + name);
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : BLOCKS) {
            registry.register((IForgeRegistryEntry)block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerBlockRenderers(ModelRegistryEvent event) {
        for (Block block : BLOCKS) {
            ICustomItemBlock customItemBlock;
            ItemStack renderedItem;
            if (block instanceof IStateMappedBlock) {
                StateMap.Builder builder = new StateMap.Builder();
                ((IStateMappedBlock)block).setStateMapper(builder);
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)builder.func_178441_a());
            }
            if (block instanceof ICustomItemBlock && !(renderedItem = (customItemBlock = (ICustomItemBlock)block).getRenderedItem()).func_190926_b()) {
                Map<Integer, ResourceLocation> map = ChargersMod.proxy.getItemModelMap(renderedItem.func_77973_b());
                ModelResourceLocation model = (ModelResourceLocation)map.get(renderedItem.func_77960_j());
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)model);
                continue;
            }
            ResourceLocation name = block.getRegistryName();
            if (block instanceof ISubtypeItemBlockModelDefinition) {
                ISubtypeItemBlockModelDefinition subtypeBlock = (ISubtypeItemBlockModelDefinition)block;
                for (int i = 0; i < subtypeBlock.getSubtypeNumber(); ++i) {
                    int meta = subtypeBlock.getSubtypeMeta(i);
                    ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(name.func_110624_b() + ":" + String.format(subtypeBlock.getSubtypeName(meta), name.func_110623_a()), "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    public static interface IStateMappedBlock {
        @SideOnly(value=Side.CLIENT)
        public void setStateMapper(StateMap.Builder var1);
    }

    public static interface ISubtypeItemBlockModelDefinition {
        public int getSubtypeNumber();

        public String getSubtypeName(int var1);

        default public int getSubtypeMeta(int subtype) {
            return subtype;
        }
    }

    public static interface ICustomItemBlock {
        @Nonnull
        default public ItemBlock getItemBlock() {
            if (Item.func_150898_a((Block)((Block)this)) != Items.field_190931_a) {
                return (ItemBlock)Item.func_150898_a((Block)((Block)this));
            }
            return new ItemBlock((Block)this);
        }

        @SideOnly(value=Side.CLIENT)
        default public ItemStack getRenderedItem() {
            return ItemStack.field_190927_a;
        }
    }
}

