/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.handler;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.darkhax.bookshelf.lib.MCColor;
import net.darkhax.huntingdim.HuntingDimension;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.FileUtils;

public class ConfigurationHandler {
    public static File directory = new File("config/huntingdim/");
    public static File configFile = new File(directory, "huntingdim.cfg");
    public static File worldPreset = new File(directory, "worldgen.json");
    public static Configuration config;
    public static String generatorPreset;
    public static int dimensionId;
    public static boolean quickPotionWearOff;
    public static double lootingChance;
    public static double expChance;
    public static double expMultiplier;
    public static int buffArmor;
    public static float buffHealth;
    public static float buffAttack;
    public static boolean mimicSurfaceWorld;
    public static String worldType;
    public static String defaultBiome;
    public static boolean allowHostileInOverworld;
    public static boolean allowPeacefulInHunting;
    public static boolean allowRespawn;
    public static int chanceSound;
    public static int chanceSpawn;
    public static MCColor defaultColor;
    public static int defaultColorPacked;
    public static Vec3d defaultColorVector;
    public static int returnDimension;
    public static boolean isVoidWorld;

    public ConfigurationHandler() {
        if (!directory.exists()) {
            HuntingDimension.LOG.info("Generating config folder", new Object[0]);
            directory.mkdirs();
        }
        config = new Configuration(configFile);
        this.generatePresets();
        this.syncConfigData();
    }

    private void generatePresets() {
        File preset = new File(directory, "world_generator_settings.json");
        if (!preset.exists()) {
            HuntingDimension.LOG.info("World generator settings does not exist. Generating a new one.", new Object[0]);
            try {
                FileUtils.copyURLToFile((URL)HuntingDimension.class.getResource("/assets/huntingdim/presets/hunting_dimension_generator_settings.json"), (File)preset);
                HuntingDimension.LOG.info("Finished generating world generator settings.", new Object[0]);
            }
            catch (IOException e) {
                HuntingDimension.LOG.warn((Throwable)e, "Could not generate world generator settings!", new Object[0]);
            }
        }
        HuntingDimension.LOG.info("Reading world generator settings.", new Object[0]);
        try {
            generatorPreset = FileUtils.readFileToString((File)preset, (Charset)StandardCharsets.UTF_8);
            HuntingDimension.LOG.info("World settings loaded: " + generatorPreset.replaceAll("\\R", "").replaceAll("\\s", " "), new Object[0]);
        }
        catch (IOException e) {
            HuntingDimension.LOG.warn((Throwable)e, "Could not read world generator settings! Default will be used!", new Object[0]);
        }
    }

    private void syncConfigData() {
        HuntingDimension.LOG.info("Reading config file.", new Object[0]);
        dimensionId = config.getInt("dimensionId", "general", 28885, Integer.MIN_VALUE, Integer.MAX_VALUE, "The id for the hunting dimension.");
        quickPotionWearOff = config.getBoolean("quickPotionWearOff", "general", true, "While true, beneficial potion effects on players will wear off twice as fast.");
        lootingChance = config.getFloat("lootingChance", "general", 0.25f, 0.0f, 1.0f, "Whenever a mob dies in the hunting dimension, there is a chance that it will have +1 levels of looting applied to it's drop. Set to 0 to disable.");
        expChance = config.getFloat("expChance", "general", 0.2f, 0.0f, 1.0f, "Whenever a mob dies in the hunting dimension, there is a chance that it will drop additional exp.");
        expMultiplier = config.getFloat("expModifier", "general", 2.5f, 0.0f, 128.0f, "When a mob dies, it can drop additional exp. This changes how much more exp it will drop. Default is 2.5x.");
        buffArmor = config.getInt("buffArmor", "general", 4, 0, 30, "The amount of additional armor to give mobs that spawn in the hunting dimension.");
        buffHealth = config.getFloat("buffHealth", "general", 0.3f, 0.0f, 1000.0f, "The percentage of additional health to give mobs that spawn in the hunting dimension.");
        buffAttack = config.getFloat("buffAttack", "general", 0.3f, 0.0f, 1000.0f, "The percentage of additional attack damage to give mobs that spawn in the hunting dimension.");
        mimicSurfaceWorld = config.getBoolean("mimicSurfaceWorld", "general", false, "If true, the mining dimension will use the same world generator as the surface world. For example, if the surface is flat so will the dimension.");
        worldType = config.getString("worldType", "general", "default", "The type of world to use for the hunting dimension. Vanilla values include default, flat, largeBiomes, amplified, customized, debug_all_block_states, and default_1_1 Keep in mind that this will be ignored if you use mimicSurfaceWorld!");
        if (worldType == null) {
            HuntingDimension.LOG.error("worldType was configured to null, this is not allowed. Please resolve this in your config.", new Object[0]);
            worldType = "default";
        }
        defaultBiome = config.getString("initialBiome", "general", "minecraft:plains", "The biome to use when generating the hunting dimension. If an invalid id is used, plains will be defaulted.");
        allowHostileInOverworld = config.getBoolean("mobsInSurface", "general", true, "Should hostile mobs be allowed to spawn in the overworld?");
        allowPeacefulInHunting = config.getBoolean("allowPeacefulMobs", "general", false, "Should peaceful mobs be allowed to spawn in the hunting dimension?");
        allowRespawn = config.getBoolean("allowRespawn", "general", false, "Should players respawn inside of the hunting dimension?");
        chanceSound = config.getInt("chanceSound", "general", 100, 0, 10000, "The chance that the portal will play a sound. Default is a 1 in 100 chance.");
        chanceSpawn = config.getInt("chanceSpawn", "general", 2000, 0, 10000, "The chance that the portal will spawn a mob. Peaceful, easy, normal and hard have a 0, 1, 2, and 3 in X chance of spawning a mob, where X is the configured value.");
        returnDimension = config.getInt("returnDimension", "general", 0, Integer.MIN_VALUE, Integer.MAX_VALUE, "The dimension to go to when you return from the hunting dimension.");
        defaultColor = this.getColor("defaultColor", "colors", new Color(59, 162, 73));
        defaultColorPacked = defaultColor.getRGB();
        defaultColorVector = new Vec3d((double)defaultColor.getRedF(), (double)defaultColor.getGreenF(), (double)defaultColor.getBlueF());
        isVoidWorld = config.getBoolean("useVoidWorld", "general", false, "Whether or not the hunting dimension should be an empty void world.");
        if (config.hasChanged()) {
            HuntingDimension.LOG.info("Saving config file.", new Object[0]);
            config.save();
        }
    }

    private MCColor getColor(String type, String category, Color initial) {
        int red = config.getInt(type + "Red", category, initial.getRed(), 0, 255, "The red color value for " + type);
        int green = config.getInt(type + "Green", category, initial.getGreen(), 0, 255, "The green color value for " + type);
        int blue = config.getInt(type + "Blue", category, initial.getBlue(), 0, 255, "The blue color value for " + type);
        return new MCColor(red, green, blue);
    }

    static {
        generatorPreset = "";
        dimensionId = 28885;
        quickPotionWearOff = true;
        lootingChance = 0.25;
        expChance = 0.2;
        expMultiplier = 2.5;
        buffArmor = 0;
        buffHealth = 0.0f;
        buffAttack = 0.0f;
        mimicSurfaceWorld = false;
        worldType = "default";
        defaultBiome = "minecraft:plains";
        allowHostileInOverworld = true;
        allowPeacefulInHunting = false;
        allowRespawn = false;
        chanceSound = 100;
        chanceSpawn = 2000;
        defaultColor = new MCColor(59, 162, 73);
        defaultColorPacked = defaultColor.getRGB();
        defaultColorVector = new Vec3d((double)defaultColor.getRedF(), (double)defaultColor.getGreenF(), (double)defaultColor.getBlueF());
        returnDimension = 0;
        isVoidWorld = false;
    }
}

