/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.worldbook.client.gui;

import com.blamejared.worldbook.client.gui.GuiListWorldBookSelectionEntry;
import com.blamejared.worldbook.client.gui.ISort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;

public enum SortOrder {
    TIME_ASC(entries -> Collections.sort(entries, (o1, o2) -> o1.summary.compareTo(o2.summary))),
    TIME_DESC(entries -> Collections.sort(entries, (o1, o2) -> o2.summary.compareTo(o1.summary))),
    AZ(entries -> entries.sort((o1, o2) -> o1.summary.func_75788_b().compareToIgnoreCase(o2.summary.func_75788_b()))),
    ZA(entries -> entries.sort((o1, o2) -> o2.summary.func_75788_b().compareToIgnoreCase(o1.summary.func_75788_b())));

    private ISort sorter;

    private SortOrder(ISort sorter) {
        this.sorter = sorter;
    }

    public SortOrder cycleUp() {
        int i = this.ordinal();
        i = i + 1 < SortOrder.values().length ? ++i : 0;
        return SortOrder.values()[i];
    }

    public SortOrder cycleDown() {
        int i = this.ordinal();
        i = i - 1 >= 0 ? --i : SortOrder.values().length - 1;
        return SortOrder.values()[i];
    }

    public void sort(List<GuiListWorldSelectionEntry> list) {
        ArrayList<GuiListWorldBookSelectionEntry> list1 = new ArrayList<GuiListWorldBookSelectionEntry>();
        for (GuiListWorldSelectionEntry entry : list) {
            if (!(entry instanceof GuiListWorldBookSelectionEntry)) continue;
            list1.add((GuiListWorldBookSelectionEntry)entry);
        }
        this.sorter.sort(list1);
        list.clear();
        list.addAll(list1);
    }

    public String getName() {
        switch (this) {
            default: {
                return "Time Asc";
            }
            case TIME_DESC: {
                return "Time Desc";
            }
            case AZ: {
                return "A->Z";
            }
            case ZA: 
        }
        return "Z->A";
    }
}

