/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.plugin;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.plugin.BackupPlugin;
import aroma1997.backup.common.util.Environment;
import aroma1997.backup.corecompressions.CoreCompressionsPlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class PluginLoader {
    public static BiFunction<URL[], ClassLoader, ClassLoader> getClassLoader = URLClassLoader::new;
    private static List<BackupPlugin> plugins;

    private PluginLoader() {
    }

    private static URL[] getPotentialPlugins() {
        return (URL[])CompressionHelper.listFiles(new File(Environment.getEnv().getMCDir(), "mods")).keySet().stream().filter(file -> file.getName().endsWith(".jar")).map(File::toURI).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).filter(Predicate.isEqual(PluginLoader.getOwnURL()).negate()).toArray(URL[]::new);
    }

    private static URL getOwnURL() {
        URL url = PluginLoader.class.getProtectionDomain().getCodeSource().getLocation();
        String str = url + "";
        if (str.startsWith("jar:")) {
            int classIndex = str.lastIndexOf(33);
            try {
                url = new URL(str.substring("jar:".length(), classIndex));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    public static void load() {
        ClassLoader cl = getClassLoader.apply(PluginLoader.getPotentialPlugins(), PluginLoader.class.getClassLoader());
        ServiceLoader<BackupPlugin> serviceLoader = ServiceLoader.load(BackupPlugin.class, cl);
        plugins = new ArrayList<BackupPlugin>();
        plugins.add(new CoreCompressionsPlugin());
        for (BackupPlugin plugin : serviceLoader) {
            if (plugins.stream().map(BackupPlugin::getName).anyMatch(Predicate.isEqual(plugin.getName()))) {
                throw new IllegalStateException("Cannot load plugin " + plugin.getName() + " because it is already loaded.");
            }
            plugins.add(plugin);
        }
        Collections.sort(plugins);
    }

    public static Collection<BackupPlugin> getPlugins() {
        return plugins;
    }
}

