/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.storageformat;

import aroma1997.backup.common.storageformat.IBackupStats;
import aroma1997.backup.common.storageformat.IStorageFormat;
import java.io.File;

public interface IBackupInfo
extends Comparable<IBackupInfo> {
    public File getFile();

    default public IBackupInfo getParentBackup() {
        return null;
    }

    public IBackupStats getBackupStats();

    public <T extends IBackupInfo> IStorageFormat<T> getStorageFormat();

    default public String getIdentifier() {
        return this.getFile().getPath();
    }

    @Override
    default public int compareTo(IBackupInfo other) {
        int ret = this.getBackupStats().getCreationDate().compareTo(other.getBackupStats().getCreationDate());
        if (ret == 0) {
            ret = this.getBackupStats().getWorldName().compareTo(other.getBackupStats().getWorldName());
        }
        return ret;
    }

    default public boolean isIncremental() {
        return this.getParentBackup() != null;
    }

    default public int getAmountParents() {
        IBackupInfo info = this;
        int parents = 0;
        while ((info = info.getParentBackup()) != null) {
            ++parents;
        }
        return parents;
    }

    public void delete(File var1);
}

