/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.storageformat;

import aroma1997.backup.common.compression.ICompression;
import aroma1997.backup.common.storageformat.BasicBackupInfo;
import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.IBackupRestoreInfo;
import aroma1997.backup.common.storageformat.IBackupStats;
import aroma1997.backup.common.storageformat.IStorageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class SimpleStorageFormat
implements IStorageFormat<BasicBackupInfo> {
    private final ICompression compression;
    private final String fileExtension;

    public SimpleStorageFormat(ICompression compression, String fileExtension) {
        this.compression = compression;
        this.fileExtension = fileExtension;
    }

    @Override
    public BasicBackupInfo getBackupInfo(String identifier) throws IOException {
        if (!identifier.endsWith(this.fileExtension)) {
            return null;
        }
        File file = new File(identifier);
        if (!file.exists()) {
            return null;
        }
        BasicBackupInfo info = new BasicBackupInfo(file, this);
        if (info.isValid()) {
            info.load();
            return info;
        }
        return null;
    }

    @Override
    public BasicBackupInfo createBackup(IBackupInfo parentBackup, File targetFile, Map<File, String> files, int compressionLevel, IBackupStats backupStats) throws IOException {
        File actualFile = new File(targetFile.getParentFile(), targetFile.getName() + "." + this.fileExtension);
        if (actualFile.exists()) {
            throw new FileAlreadyExistsException(targetFile.getAbsolutePath() + " already exists.");
        }
        Files.createDirectories(actualFile.getParentFile().toPath(), new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(actualFile);){
            this.compression.compress(fos, files.entrySet(), compressionLevel);
        }
        BasicBackupInfo info = new BasicBackupInfo(actualFile, this, backupStats);
        info.save();
        return info;
    }

    @Override
    public void restoreBackup(BasicBackupInfo backup, IBackupRestoreInfo target) throws IOException {
        try (FileInputStream fis = new FileInputStream(backup.getFile());){
            this.compression.decompress(fis, target::getTargetLocation);
        }
    }

    @Override
    public String getFormatIdentifier() {
        return this.fileExtension;
    }
}

