/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.commands;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.info.BackupInfoUtil;
import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.IBackupStats;
import aroma1997.backup.common.storageformat.IStorageFormat;
import aroma1997.backup.common.storageformat.StorageFormatRegistry;
import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.Main;
import aroma1997.backup.standalone.StandaloneEnv;
import aroma1997.backup.standalone.command.Command;
import aroma1997.backup.standalone.command.CommandException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CommandBackup
extends Command {
    public CommandBackup() {
        super("makeBackup", "backup");
    }

    @Override
    public void printCommandUsage() {
        IOHelper.printUserOut(this.getName() + " <type> [incremental]");
        IOHelper.printUserOut("");
        IOHelper.printUserOut("Use the filter command to set the world name.");
        IOHelper.printUserOut("Use the setBackupDir command to set the directory, where the backup will be placed.");
        IOHelper.printUserOut("Use the listBackupTypes command to get a list of available backup types.");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        StandaloneEnv env = Main.env;
        if (env.getWorldName() == null) {
            throw new CommandException("WorldName is not set. Please set the world name using the filter command.");
        }
        File world = new File(env.getMCDir(), "saves/" + env.getWorldName());
        if (!world.exists() || !new File(world, "level.dat").exists()) {
            world = new File(env.getMCDir(), env.getWorldName());
        }
        if (args.length <= 0) {
            throw new CommandException("No backupType specified. Run \"listBackupTypes\" to get a list of available backupTypes");
        }
        IStorageFormat<?> format = StorageFormatRegistry.INSTANCE.getStorageFormat(args[0]);
        if (format == null) {
            throw new CommandException("Specified backupType is invalid.");
        }
        try {
            List<IBackupInfo> infos;
            IBackupInfo parent = null;
            if (args.length > 1 && args[1].equalsIgnoreCase("incremental") && !(infos = BackupInfoUtil.listBackupsForWorld(env.getBackupDir(), env.getWorldName())).isEmpty()) {
                parent = Collections.max(infos);
            }
            File backupTarget = new File(env.getBackupDir(), "Backup-" + env.getWorldName() + new Date().getTime());
            Object info = format.createBackup(parent, backupTarget, CompressionHelper.listFiles(world), env.getCompressionRate(), new IBackupStats.BackupStats(new Date(), env.getWorldName()));
            IOHelper.printUserOut("Successfully created backup to " + backupTarget.getAbsolutePath());
            IOHelper.printUserOut("BackupIdentifier is: " + info.getIdentifier());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException("A error occured, while executing the command.");
        }
    }
}

