/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.ogdragon.common;

import com.gendeathrow.ogdragon.blocks.ModBlocks;
import com.gendeathrow.ogdragon.common.handlers.OGDragonFightManager;
import com.gendeathrow.ogdragon.core.ConfigHandler;
import com.gendeathrow.ogdragon.core.OGDragon;
import com.gendeathrow.ogdragon.entity.EntityDragonOG;
import com.gendeathrow.ogdragon.utils.ObfHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class GD_EventHandler {
    public static boolean isWorldSpawn = false;
    public static List<String> worldTypeWhitelist = new ArrayList<String>();
    public static boolean isWhiteList = false;
    private static ArrayList<Entity> spawnList = new ArrayList();
    static int tick = 0;

    public static void parseWorldTypeList(String[] strings) {
        for (String id : strings) {
            if (GD_EventHandler.addWorldType(id) != null) continue;
            OGDragon.logger.error("WorldType (" + id + " )does not exist in the world type whitelist/blacklist");
        }
    }

    public static WorldType addWorldType(String worldtypeID) {
        WorldType type = WorldType.func_77130_a((String)worldtypeID);
        if (!worldTypeWhitelist.contains(worldtypeID.toLowerCase().trim())) {
            worldTypeWhitelist.add(worldtypeID.toLowerCase().trim());
        }
        return type;
    }

    public static boolean isWorldTypeInList(WorldType type) {
        return worldTypeWhitelist.contains(type.func_77127_a().toLowerCase().trim());
    }

    @SubscribeEvent
    public static void QueueSpawn(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && spawnList.size() > 0 && tick++ >= 40) {
            GD_EventHandler.spawnList.get((int)0).field_70170_p.func_72838_d(spawnList.get(0));
            spawnList.remove(0);
            tick = 0;
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        WorldType worldtype = event.getWorld().func_72912_H().func_76067_t();
        if (!isWhiteList && GD_EventHandler.isWorldTypeInList(worldtype)) {
            return;
        }
        if (isWhiteList && !GD_EventHandler.isWorldTypeInList(worldtype)) {
            return;
        }
        if (event.getWorld().field_73011_w instanceof WorldProviderEnd && !ConfigHandler.spawnOnlyWithEgg && ConfigHandler.replaceVanillaDragon) {
            OGDragonFightManager.changeToOGFightManager(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        WorldType worldtype = event.getEntity().field_70170_p.func_72912_H().func_76067_t();
        if (!isWhiteList && GD_EventHandler.isWorldTypeInList(worldtype)) {
            return;
        }
        if (isWhiteList && !GD_EventHandler.isWorldTypeInList(worldtype)) {
            return;
        }
        if (event.getEntity() instanceof EntityDragon && !(event.getEntity() instanceof EntityDragonOG)) {
            NBTTagCompound data = event.getEntity().getEntityData();
            EntityDragon dragon = (EntityDragon)event.getEntity();
            if (ConfigHandler.spawnOnlyWithEgg && ConfigHandler.spawnEgg) {
                event.setCanceled(true);
                dragon.func_70106_y();
                ObfHelper.setDragonkilled(dragon.func_184664_cU());
            } else if (!ConfigHandler.spawnOnlyWithEgg && ConfigHandler.replaceVanillaDragon) {
                BossInfoServer bossinfo = ObfHelper.getBossInfoServer(dragon.func_184664_cU());
                if (bossinfo != null) {
                    bossinfo.func_186758_d(false);
                }
                event.setCanceled(true);
                dragon.func_70106_y();
                EntityDragonOG OGDragon2 = new EntityDragonOG(dragon.field_70170_p);
                OGDragon2.func_70080_a(dragon.field_70165_t, dragon.field_70163_u, dragon.field_70161_v, dragon.field_70177_z, dragon.field_70125_A);
                spawnList.add((Entity)OGDragon2);
            }
        } else if (event.getEntity() instanceof EntityEnderman && ConfigHandler.spawnEgg && ConfigHandler.endermanHoldEggs && (double)event.getWorld().field_73012_v.nextFloat() <= 0.05) {
            if (!EntityEnderman.getCarriable((Block)ModBlocks.gdDragonEgg)) {
                EntityEnderman.setCarriable((Block)ModBlocks.gdDragonEgg, (boolean)true);
            }
            ((EntityEnderman)event.getEntity()).func_175490_a(ModBlocks.gdDragonEgg.func_176223_P());
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ogdragon")) {
            ConfigHandler.config.save();
            ConfigHandler.loadConfig();
        }
    }
}

