/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.ogdragon.common.handlers;

import com.gendeathrow.ogdragon.core.ConfigHandler;
import com.gendeathrow.ogdragon.entity.EntityDragonOG;
import com.gendeathrow.ogdragon.utils.ObfHelper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.end.DragonSpawnManager;
import net.minecraft.world.gen.feature.WorldGenEndGateway;
import net.minecraft.world.gen.feature.WorldGenEndPodium;
import net.minecraft.world.gen.feature.WorldGenSpikes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OGDragonFightManager
extends DragonFightManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<EntityPlayerMP> VALID_PLAYER = Predicates.and((Predicate)EntitySelectors.field_94557_a, (Predicate)EntitySelectors.func_188443_a((double)0.0, (double)128.0, (double)0.0, (double)192.0));
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentString(new TextComponentTranslation("entity.EnderDragon.name", new Object[0]).func_150254_d() + "+"), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private final WorldServer world;
    private final List<Integer> gateways = Lists.newArrayList();
    private final BlockPattern portalPattern;
    private int ticksSinceDragonSeen;
    private int aliveCrystals;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan;
    private boolean dragonKilled;
    private boolean previouslyKilled;
    private UUID dragonUniqueId;
    private boolean scanForLegacyFight = true;
    private BlockPos exitPortalLocation;
    private DragonSpawnManager respawnState;
    private int respawnStateTicks;
    private List<EntityEnderCrystal> crystals;

    public OGDragonFightManager(WorldServer worldIn, NBTTagCompound compound) {
        super(worldIn, compound);
        this.world = worldIn;
        if (compound.func_150297_b("DragonKilled", 99)) {
            if (compound.func_186855_b("DragonUUID")) {
                this.dragonUniqueId = compound.func_186857_a("DragonUUID");
            }
            this.dragonKilled = compound.func_74767_n("DragonKilled");
            this.previouslyKilled = compound.func_74767_n("PreviouslyKilled");
            boolean bl = this.scanForLegacyFight = !compound.func_74767_n("LegacyScanPerformed");
            if (compound.func_74767_n("IsRespawning")) {
                this.respawnState = DragonSpawnManager.START;
            }
            if (compound.func_150297_b("ExitPortalLocation", 10)) {
                this.exitPortalLocation = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("ExitPortalLocation"));
            }
        } else {
            this.dragonKilled = true;
            this.previouslyKilled = true;
        }
        if (compound.func_150297_b("Gateways", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Gateways", 3);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.gateways.add(nbttaglist.func_186858_c(i));
            }
        } else {
            this.gateways.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.gateways, new Random(worldIn.func_72905_C()));
        }
        this.portalPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  "}).func_177659_a(new String[]{"       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       "}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150357_h))).func_177661_b();
    }

    public static DragonFightManager changeToOGFightManager(World world) {
        if (world.field_73011_w instanceof WorldProviderEnd) {
            DragonFightManager manager = ((WorldProviderEnd)world.field_73011_w).func_186063_s();
            BossInfoServer bossinfo = ObfHelper.getBossInfoServer(manager);
            if (bossinfo != null) {
                bossinfo.func_186758_d(false);
            }
            if (!(manager instanceof OGDragonFightManager)) {
                NBTTagCompound nbttagcompound = world.func_72912_H().getDimensionData(world.field_73011_w.getDimension());
                OGDragonFightManager newManager = world instanceof WorldServer ? new OGDragonFightManager((WorldServer)world, nbttagcompound.func_74775_l("DragonFight")) : null;
                ObfHelper.switchOutFightManager((WorldProviderEnd)world.field_73011_w, newManager);
                return newManager;
            }
            return manager;
        }
        return null;
    }

    public NBTTagCompound func_186088_a() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (this.dragonUniqueId != null) {
            nbttagcompound.func_186854_a("DragonUUID", this.dragonUniqueId);
        }
        nbttagcompound.func_74757_a("DragonKilled", this.dragonKilled);
        nbttagcompound.func_74757_a("PreviouslyKilled", this.previouslyKilled);
        nbttagcompound.func_74757_a("LegacyScanPerformed", !this.scanForLegacyFight);
        if (this.exitPortalLocation != null) {
            nbttagcompound.func_74782_a("ExitPortalLocation", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.exitPortalLocation));
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : this.gateways) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        nbttagcompound.func_74782_a("Gateways", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    public void func_186105_b() {
        this.bossInfo.func_186758_d(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.bossInfo.func_186757_c().isEmpty()) {
            if (this.scanForLegacyFight) {
                LOGGER.info("Scanning for legacy world dragon fight...");
                this.loadChunks();
                this.scanForLegacyFight = false;
                boolean flag = this.hasDragonBeenKilled();
                if (flag) {
                    LOGGER.info("Found that the dragon has been killed in this world already.");
                    this.previouslyKilled = true;
                } else {
                    LOGGER.info("Found that the dragon has not yet been killed in this world.");
                    this.previouslyKilled = false;
                    this.generatePortal(false);
                }
                List list = this.world.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
                if (list.isEmpty()) {
                    this.dragonKilled = true;
                } else {
                    EntityDragon entitydragon = (EntityDragon)list.get(0);
                    this.dragonUniqueId = entitydragon.func_110124_au();
                    LOGGER.info("Found that there's a dragon still alive ({})", (Object)entitydragon);
                    this.dragonKilled = false;
                    if (!flag) {
                        LOGGER.info("But we didn't have a portal, let's remove it.");
                        entitydragon.func_70106_y();
                        this.dragonUniqueId = null;
                    }
                }
                if (!this.previouslyKilled && this.dragonKilled) {
                    this.dragonKilled = false;
                }
            }
            if (this.respawnState != null) {
                if (this.crystals == null) {
                    this.respawnState = null;
                    this.func_186106_e();
                }
                this.respawnState.func_186079_a(this.world, (DragonFightManager)this, this.crystals, this.respawnStateTicks++, this.exitPortalLocation);
            }
            if (!this.dragonKilled) {
                if (this.dragonUniqueId == null || ++this.ticksSinceDragonSeen >= 1200) {
                    this.loadChunks();
                    List list1 = this.world.func_175644_a(EntityDragonOG.class, EntitySelectors.field_94557_a);
                    if (list1.isEmpty()) {
                        LOGGER.debug("Haven't seen the dragon, respawning it");
                        this.createNewDragon();
                    } else {
                        LOGGER.debug("Haven't seen our dragon, but found another one to use.");
                        this.dragonUniqueId = ((EntityDragonOG)((Object)list1.get(0))).func_110124_au();
                    }
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100) {
                    this.findAliveCrystals();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        }
    }

    protected void func_186095_a(DragonSpawnManager state) {
        if (this.respawnState == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnStateTicks = 0;
        if (state == DragonSpawnManager.END) {
            this.respawnState = null;
            this.dragonKilled = false;
            EntityDragonOG entitydragon = this.createNewDragon();
            for (EntityPlayerMP entityplayermp : this.bossInfo.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(entityplayermp, (Entity)entitydragon);
            }
        } else {
            this.respawnState = state;
        }
    }

    private boolean hasDragonBeenKilled() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.world.func_72964_e(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    if (!(tileentity instanceof TileEntityEndPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper findExitPortal() {
        int k;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.world.func_72964_e(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    BlockPattern.PatternHelper blockpattern$patternhelper;
                    if (!(tileentity instanceof TileEntityEndPortal) || (blockpattern$patternhelper = this.portalPattern.func_177681_a((World)this.world, tileentity.func_174877_v())) == null) continue;
                    BlockPos blockpos = blockpattern$patternhelper.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.exitPortalLocation == null && blockpos.func_177958_n() == 0 && blockpos.func_177952_p() == 0) {
                        this.exitPortalLocation = blockpos;
                    }
                    return blockpattern$patternhelper;
                }
            }
        }
        for (int l = k = this.world.func_175645_m(WorldGenEndPodium.field_186139_a).func_177956_o(); l >= 0; --l) {
            BlockPattern.PatternHelper blockpattern$patternhelper1 = this.portalPattern.func_177681_a((World)this.world, new BlockPos(WorldGenEndPodium.field_186139_a.func_177958_n(), l, WorldGenEndPodium.field_186139_a.func_177952_p()));
            if (blockpattern$patternhelper1 == null) continue;
            if (this.exitPortalLocation == null) {
                this.exitPortalLocation = blockpattern$patternhelper1.func_177670_a(3, 3, 3).func_177508_d();
            }
            return blockpattern$patternhelper1;
        }
        return null;
    }

    private void loadChunks() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                this.world.func_72964_e(i, j);
            }
        }
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (EntityPlayerMP entityplayermp : this.world.func_175661_b(EntityPlayerMP.class, VALID_PLAYER)) {
            this.bossInfo.func_186760_a(entityplayermp);
            set.add(entityplayermp);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.bossInfo.func_186757_c());
        set1.removeAll(set);
        for (EntityPlayerMP entityplayermp1 : set1) {
            this.bossInfo.func_186761_b(entityplayermp1);
        }
    }

    private void findAliveCrystals() {
        this.ticksSinceCrystalsScanned = 0;
        this.aliveCrystals = 0;
        for (WorldGenSpikes.EndSpike worldgenspikes$endspike : BiomeEndDecorator.func_185426_a((World)this.world)) {
            this.aliveCrystals += this.world.func_72872_a(EntityEnderCrystal.class, worldgenspikes$endspike.func_186153_f()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", (Object)this.aliveCrystals);
    }

    public void func_186096_a(EntityDragon dragon) {
        if (dragon.func_110124_au().equals(this.dragonUniqueId)) {
            this.bossInfo.func_186735_a(0.0f);
            this.bossInfo.func_186758_d(false);
            this.generatePortal(true);
            this.spawnNewGateway();
            if (ConfigHandler.dropLootChest) {
                this.world.func_175656_a(this.world.func_175645_m(WorldGenEndPodium.field_186139_a), Blocks.field_150486_ae.func_176223_P());
                EntityDragonOG.generateDragonLoot((World)this.world, (TileEntityChest)this.world.func_175625_s(this.world.func_175645_m(WorldGenEndPodium.field_186139_a)));
            } else if (!this.previouslyKilled) {
                this.world.func_175656_a(this.world.func_175645_m(WorldGenEndPodium.field_186139_a), Blocks.field_150380_bt.func_176223_P());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    private void spawnNewGateway() {
        if (!this.gateways.isEmpty()) {
            int i = this.gateways.remove(this.gateways.size() - 1);
            int j = (int)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            int k = (int)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            this.generateGateway(new BlockPos(j, 75, k));
        }
    }

    private void generateGateway(BlockPos pos) {
        this.world.func_175718_b(3000, pos, 0);
        new WorldGenEndGateway().func_180709_b((World)this.world, new Random(), pos);
    }

    private void generatePortal(boolean active) {
        WorldGenEndPodium worldgenendpodium = new WorldGenEndPodium(active);
        if (this.exitPortalLocation == null) {
            this.exitPortalLocation = this.world.func_175672_r(WorldGenEndPodium.field_186139_a).func_177977_b();
            while (this.world.func_180495_p(this.exitPortalLocation).func_177230_c() == Blocks.field_150357_h && this.exitPortalLocation.func_177956_o() > this.world.func_181545_F()) {
                this.exitPortalLocation = this.exitPortalLocation.func_177977_b();
            }
        }
        worldgenendpodium.func_180709_b((World)this.world, new Random(), this.exitPortalLocation);
    }

    private EntityDragonOG createNewDragon() {
        this.world.func_175726_f(new BlockPos(0, 128, 0));
        EntityDragonOG entitydragon = new EntityDragonOG((World)this.world);
        entitydragon.func_70012_b(0.0, 128.0, 0.0, this.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.world.func_72838_d((Entity)entitydragon);
        this.dragonUniqueId = entitydragon.func_110124_au();
        return entitydragon;
    }

    public void func_186099_b(EntityDragon dragonIn) {
        if (dragonIn.func_110124_au().equals(this.dragonUniqueId)) {
            this.bossInfo.func_186735_a(dragonIn.func_110143_aJ() / dragonIn.func_110138_aP());
            this.ticksSinceDragonSeen = 0;
            if (dragonIn.func_145818_k_()) {
                this.bossInfo.func_186739_a(dragonIn.func_145748_c_());
            }
        }
    }

    public int func_186092_c() {
        return this.aliveCrystals;
    }

    public void func_186090_a(EntityEnderCrystal crystal, DamageSource dmgSrc) {
        if (this.respawnState != null && this.crystals.contains(crystal)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnState = null;
            this.respawnStateTicks = 0;
            this.func_186087_f();
            this.generatePortal(true);
        } else {
            this.findAliveCrystals();
            Entity entity = this.world.func_175733_a(this.dragonUniqueId);
            if (entity instanceof EntityDragon) {
                ((EntityDragon)entity).func_184672_a(crystal, new BlockPos((Entity)crystal), dmgSrc);
            }
        }
    }

    public boolean func_186102_d() {
        return this.previouslyKilled;
    }

    public void func_186106_e() {
        if (this.dragonKilled && this.respawnState == null) {
            BlockPos blockpos = this.exitPortalLocation;
            if (blockpos == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.PatternHelper blockpattern$patternhelper = this.findExitPortal();
                if (blockpattern$patternhelper == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.generatePortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & temporarily using it.");
                }
                blockpos = this.exitPortalLocation;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos blockpos1 = blockpos.func_177981_b(1);
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                List list = this.world.func_72872_a(EntityEnderCrystal.class, new AxisAlignedBB(blockpos1.func_177967_a(enumfacing, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.respawnDragon(list1);
        }
    }

    private void respawnDragon(List<EntityEnderCrystal> crystalsIn) {
        if (this.dragonKilled && this.respawnState == null) {
            BlockPattern.PatternHelper blockpattern$patternhelper = this.findExitPortal();
            while (blockpattern$patternhelper != null) {
                for (int i = 0; i < this.portalPattern.func_177684_c(); ++i) {
                    for (int j = 0; j < this.portalPattern.func_177685_b(); ++j) {
                        for (int k = 0; k < this.portalPattern.func_185922_a(); ++k) {
                            BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, k);
                            if (blockworldstate.func_177509_a().func_177230_c() != Blocks.field_150357_h && blockworldstate.func_177509_a().func_177230_c() != Blocks.field_150384_bq) continue;
                            this.world.func_175656_a(blockworldstate.func_177508_d(), Blocks.field_150377_bs.func_176223_P());
                        }
                    }
                }
                blockpattern$patternhelper = this.findExitPortal();
            }
            this.respawnState = DragonSpawnManager.START;
            this.respawnStateTicks = 0;
            this.generatePortal(false);
            this.crystals = crystalsIn;
        }
    }

    public void func_186087_f() {
        for (WorldGenSpikes.EndSpike worldgenspikes$endspike : BiomeEndDecorator.func_185426_a((World)this.world)) {
            for (EntityEnderCrystal entityendercrystal : this.world.func_72872_a(EntityEnderCrystal.class, worldgenspikes$endspike.func_186153_f())) {
                entityendercrystal.func_184224_h(false);
                entityendercrystal.func_184516_a((BlockPos)null);
            }
        }
    }

    public void addPlayer(EntityPlayerMP player) {
        this.bossInfo.func_186760_a(player);
    }

    public void removePlayer(EntityPlayerMP player) {
        this.bossInfo.func_186761_b(player);
    }
}

