/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.ogdragon.core;

import com.gendeathrow.ogdragon.common.GD_EventHandler;
import com.gendeathrow.ogdragon.utils.LootRegisty;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static final File configDir = new File("config/ogdragon");
    public static Configuration config;
    public static boolean spawnOnlyWithEgg;
    public static boolean spawnEgg;
    public static boolean endermanHoldEggs;
    public static int dragonPortalY;
    public static boolean hasDragonRiders;
    public static float DragonRidersChance;
    public static boolean showTextNotification;
    public static boolean dropLootChest;
    public static HashMap<Integer, ItemStack> lootList;
    public static float slotPrecentage;
    public static int maxLootDrop;
    public static boolean replaceVanillaDragon;
    private static Gson gson;

    public static void load() {
        ConfigHandler.loadConfig();
        ConfigHandler.loadLootChest();
    }

    public static void loadConfig() {
        File f = new File(configDir, "ogdragon.cfg");
        config = new Configuration(f);
        config.load();
        String NameSpawnEgg = "Dragon Spawn Egg";
        String NameSpawnOnlyWithEgg = "Spawn Dragon Only With Egg";
        String NameEndermanHoldEgg = "Enderman Spawns with Eggs";
        String NameReplaceVanillaDragon = "Replace Vanilla Dragon with OGDragon";
        String NameDropLootChest = "Drop Loot Chest";
        String NameSlotPrecentage = "Slot Drop Precentage";
        String NameDragonPortalY = "Dragon Portal Y Value";
        String NameHasDragonRiders = "Dragon Riders";
        String NameDragonRidersChance = "Dragon Riders Chance";
        String NameShowTextNotification = "Show Dragon Notifications";
        if (config.hasKey("general", "Will Replace Vanilla Dragon When Spawned")) {
            config.renameProperty("general", "Will Replace Vanilla Dragon When Spawned", "Replace Vanilla Dragon with OGDragon");
        }
        if (config.hasKey("general", "Prevent Vanilla Dragon Spawn")) {
            config.renameProperty("general", "Prevent Vanilla Dragon Spawn", "Spawn Dragon Only With Egg");
        }
        spawnEgg = config.getBoolean(NameSpawnEgg, "general", spawnEgg, "Adds a Block Dragon Egg that will spawn EnderDragon when poked! (Rare chance Endermen will be carry the eggs)");
        endermanHoldEggs = config.getBoolean(NameEndermanHoldEgg, "general", endermanHoldEggs, "Will Enderman have a rare chance spawn with Dragon Eggs?");
        spawnOnlyWithEgg = config.getBoolean(NameSpawnOnlyWithEgg, "general", spawnOnlyWithEgg, "Stops Dragon from spawning into the ender. Dragon has to be spawned with a dragon egg. ");
        replaceVanillaDragon = config.getBoolean(NameReplaceVanillaDragon, "general", replaceVanillaDragon, "Replaces Vanilla Dragon, when ever its spawned by a nother mod.");
        dropLootChest = config.getBoolean(NameDropLootChest, "general", dropLootChest, "GDAddons Dragon will drop a Loot Chest (Vanilla Dragon will not Drop) Add Items to dragonlootchest.json");
        slotPrecentage = config.getFloat(NameSlotPrecentage, "general", slotPrecentage, 0.05f, 1.0f, "Change the Drop Precentage for each slot in the dragon loot chest.");
        dragonPortalY = config.getInt(NameDragonPortalY, "general", 64, 1, 255, "Set the portals Y value when it generates.");
        hasDragonRiders = config.getBoolean(NameHasDragonRiders, "general", hasDragonRiders, "Has a chance to spawn dragon riders");
        DragonRidersChance = config.getFloat(NameDragonRidersChance, "general", DragonRidersChance, 0.05f, 1.0f, "Change the precentage for chance to spawn a dragon rider on enderdragon.");
        showTextNotification = config.getBoolean(NameShowTextNotification, "general", showTextNotification, "Will display chat message about how to use the dragon egg.");
        config.setCategoryPropertyOrder("general", Arrays.asList(NameSpawnEgg, NameSpawnOnlyWithEgg, NameEndermanHoldEgg, NameReplaceVanillaDragon, NameDropLootChest, NameSlotPrecentage, NameShowTextNotification, NameDragonPortalY, NameHasDragonRiders, NameDragonRidersChance));
        GD_EventHandler.isWhiteList = config.getBoolean("is Whitelist", "WhiteList/BlackList", false, "Is the WorldType list a Whitelist(true) or Blacklist(false)");
        String types = "";
        for (WorldType type : WorldType.field_77139_a) {
            if (type == null) continue;
            types = types + type.func_77127_a() + ", \n";
        }
        config.addCustomCategoryComment("WhiteList/BlackList", "This list allows you to set this mod to only work on certain world types. \n List of all Worldtypes loaded: \n" + types + "\n Delete this comment if you would like this list to re-generate.");
        GD_EventHandler.parseWorldTypeList(config.get("WhiteList/BlackList", "Worldtype list", new String[0]).getStringList());
        config.save();
    }

    public static void loadLootChest() {
        if (dropLootChest) {
            File f = new File(configDir, "dragonloot.json");
            if (!f.exists()) {
                ConfigHandler.writeDefaultLoot();
            }
            LootRegisty.LoadDragonLoot(f);
        }
    }

    public static void loadDragonSpawns() {
        if (hasDragonRiders) {
            File f = new File(configDir, "dragonriders.json");
            if (!f.exists()) {
                // empty if block
            }
            LootRegisty.LoadDragonLoot(f);
        }
    }

    private static void writeDefaultLoot() {
        try {
            FileWriter fw = new FileWriter(new File(configDir, "dragonloot.json"));
            JsonObject mainJson = new JsonObject();
            JsonObject tutJson = new JsonObject();
            tutJson.addProperty("item", "Place the item id you want to drop");
            tutJson.addProperty("meta", "enter the metadata into default: 0");
            tutJson.addProperty("weight", "Enter the weight random chance for this item. -1 means it will always drop.");
            tutJson.addProperty("stackSize", "The stack size of the item. If you want random drop you can add min/max like this: 3~8");
            tutJson.addProperty("nbt", "input nbtdata here.");
            ItemStack dragonSkull = new ItemStack(Items.field_151144_bL, 1, 5);
            ItemStack potion = new ItemStack((Item)Items.field_151068_bn);
            ItemStack regen = potion.func_77946_l();
            ItemStack str = potion.func_77946_l();
            ItemStack swift = potion.func_77946_l();
            ItemStack leap = potion.func_77946_l();
            ItemStack vison = potion.func_77946_l();
            ItemStack invis = potion.func_77946_l();
            try {
                regen.func_77982_d(JsonToNBT.func_180713_a((String)"{Potion:\"minecraft:long_regeneration\"}"));
                str.func_77982_d(JsonToNBT.func_180713_a((String)"{Potion:\"minecraft:long_strength\"}"));
                swift.func_77982_d(JsonToNBT.func_180713_a((String)"{Potion:\"minecraft:long_swiftness\"}"));
                leap.func_77982_d(JsonToNBT.func_180713_a((String)"{Potion:\"minecraft:long_leaping\"}"));
                vison.func_77982_d(JsonToNBT.func_180713_a((String)"{Potion:\"minecraft:night_vision\"}"));
                invis.func_77982_d(JsonToNBT.func_180713_a((String)"{Potion:\"minecraft:long_invisibility\"}"));
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
            mainJson.add("_comment", (JsonElement)tutJson);
            mainJson.add("dragon_head", (JsonElement)ConfigHandler.createJsonForLoot(dragonSkull, -1, 1));
            mainJson.add("golden_apple", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Items.field_151153_ao), 10, 1));
            mainJson.add("golden_apple_enc", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Items.field_151153_ao, 1, 1), 5, 1));
            mainJson.add("dragon_breath", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Items.field_185157_bK), 20, 1));
            mainJson.add("diamond_block", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Blocks.field_150484_ah), 10, 1, 2));
            mainJson.add("pearls", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Items.field_151079_bi), 30, 3, 8));
            mainJson.add("ender_chest", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Blocks.field_150477_bB), 5, 1));
            mainJson.add("diamonds", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Items.field_151045_i), 20, 3, 8));
            mainJson.add("experiance", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Items.field_151062_by), 30, 5, 10));
            mainJson.add("emeralds", (JsonElement)ConfigHandler.createJsonForLoot(new ItemStack(Items.field_151166_bC), 15, 2, 6));
            mainJson.add("potion_regen", (JsonElement)ConfigHandler.createJsonForLoot(regen, 10, 1));
            mainJson.add("potion_strength", (JsonElement)ConfigHandler.createJsonForLoot(str, 10, 1));
            mainJson.add("potion_switftness", (JsonElement)ConfigHandler.createJsonForLoot(swift, 10, 1));
            mainJson.add("potion_leaping", (JsonElement)ConfigHandler.createJsonForLoot(leap, 10, 1));
            mainJson.add("potion_nightvision", (JsonElement)ConfigHandler.createJsonForLoot(vison, 10, 1));
            mainJson.add("potion_invisibility", (JsonElement)ConfigHandler.createJsonForLoot(invis, 10, 1));
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)mainJson, (Appendable)fw);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JsonObject createJsonForLoot(ItemStack stack, int weight, int cnt) {
        return ConfigHandler.createJsonForLoot(stack, weight, cnt, cnt);
    }

    private static JsonObject createJsonForLoot(ItemStack stack, int weight, int min, int max) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", stack.func_77973_b().getRegistryName().toString());
        if (stack.func_77960_j() != 0) {
            obj.addProperty("meta", (Number)stack.func_77960_j());
        }
        obj.addProperty("weight", (Number)weight);
        if (min != max) {
            obj.addProperty("stackSize", min + "~" + max);
        } else {
            obj.addProperty("stackSize", (Number)max);
        }
        if (stack.func_77942_o()) {
            JsonElement element = (JsonElement)gson.fromJson(stack.func_77978_p().toString(), JsonElement.class);
            obj.add("nbt", (JsonElement)element.getAsJsonObject());
        }
        return obj;
    }

    static {
        spawnOnlyWithEgg = false;
        spawnEgg = true;
        endermanHoldEggs = true;
        dragonPortalY = 64;
        hasDragonRiders = true;
        DragonRidersChance = 0.25f;
        showTextNotification = true;
        dropLootChest = true;
        lootList = new HashMap();
        slotPrecentage = 0.15f;
        maxLootDrop = 4;
        replaceVanillaDragon = true;
        gson = new Gson();
    }
}

