/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.ogdragon.entity;

import com.gendeathrow.ogdragon.core.ConfigHandler;
import com.gendeathrow.ogdragon.entity.dragonRiders.EntityRider;
import com.gendeathrow.ogdragon.utils.Loot;
import com.gendeathrow.ogdragon.utils.LootRegisty;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDragonOG
extends EntityDragon {
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] field_70979_e = new double[64][3];
    public int field_70976_f = -1;
    public float field_70991_bC;
    public float field_70988_bD;
    public boolean forceNewTarget;
    public boolean field_70994_bF;
    private Entity target;
    public int field_70995_bG;
    public EntityEnderCrystal field_70992_bH;
    public Entity riddenBy;
    private int field_188664_b;
    private EntityAreaEffectCloud areaEffectCloud;
    public DragonFightManager field_184676_bI;
    BossInfoServer bossInfo = null;
    private static final Predicate<EntityPlayerMP> VALID_PLAYER = Predicates.and((Predicate)EntitySelectors.field_94557_a, (Predicate)EntitySelectors.func_188443_a((double)0.0, (double)128.0, (double)0.0, (double)192.0));
    public int nextBreathAttack = 200;
    public boolean targetHit = false;

    public EntityDragonOG(World worldIn) {
        super(worldIn);
        this.field_70986_h = new MultiPartEntityPart((IEntityMultiPart)this, "head", 6.0f, 6.0f);
        this.field_70987_i = new MultiPartEntityPart((IEntityMultiPart)this, "body", 8.0f, 8.0f);
        this.field_70985_j = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.field_70984_by = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.field_70982_bz = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.field_70983_bA = new MultiPartEntityPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.field_70990_bB = new MultiPartEntityPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.field_70977_g = new MultiPartEntityPart[]{this.field_70986_h, this.field_70987_i, this.field_70985_j, this.field_70984_by, this.field_70982_bz, this.field_70983_bA, this.field_70990_bB};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(16.0f, 8.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.targetY = 100.0;
        this.field_70158_ak = true;
        if (!worldIn.field_72995_K && worldIn.field_73011_w instanceof WorldProviderEnd) {
            DragonFightManager manager = ((WorldProviderEnd)worldIn.field_73011_w).func_186063_s();
            this.field_184676_bI = ((WorldProviderEnd)worldIn.field_73011_w).func_186063_s();
        } else {
            this.field_184676_bI = null;
            this.bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentTranslation("entity.EnderDragon.name", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (!this.func_184207_aI() && ConfigHandler.hasDragonRiders && this.field_70170_p.field_73012_v.nextFloat() <= ConfigHandler.DragonRidersChance) {
            EntityRider rider = new EntityRider(this.field_70170_p);
            rider.func_70012_b(this.field_70165_t, this.field_70163_u + 64.0, this.field_70161_v, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            rider.func_184220_m((Entity)this);
            rider.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)rider);
            this.setRidden((Entity)rider);
            for (EntityPlayer playerIn : this.field_70170_p.field_73010_i) {
                playerIn.func_145747_a(new TextComponentTranslation(rider.func_95999_t() + rider.getRiderPower().getPowerText(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            }
        }
        return livingdata;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186761_b(player);
        }
    }

    public void setRidden(Entity entity) {
        this.riddenBy = entity;
    }

    public Entity getRidden() {
        return this.riddenBy;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        entityToUpdate.field_70125_A = this.field_70125_A;
        entityToUpdate.field_70177_z = this.field_70177_z;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.36;
    }

    public double[] func_70974_a(int p_70974_1_, float p_70974_2_) {
        if (this.func_110143_aJ() <= 0.0f) {
            p_70974_2_ = 0.0f;
        }
        p_70974_2_ = 1.0f - p_70974_2_;
        int i = this.field_70976_f - p_70974_1_ * 1 & 0x3F;
        int j = this.field_70976_f - p_70974_1_ * 1 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.field_70979_e[i][0];
        double d1 = MathHelper.func_76138_g((double)(this.field_70979_e[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_70974_2_;
        d0 = this.field_70979_e[i][1];
        d1 = this.field_70979_e[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_70974_2_;
        adouble[2] = this.field_70979_e[i][2] + (this.field_70979_e[j][2] - this.field_70979_e[i][2]) * (double)p_70974_2_;
        return adouble;
    }

    public void func_70636_d() {
        if (this.field_184676_bI == null && this.bossInfo != null) {
            this.bossInfo.func_186758_d(!this.field_70729_aU);
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        if (this.field_70170_p.field_72995_K) {
            float f = MathHelper.func_76134_b((float)(this.field_70988_bD * (float)Math.PI * 2.0f));
            float f1 = MathHelper.func_76134_b((float)(this.field_70991_bC * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.field_70991_bC = this.field_70988_bD;
        if (this.func_110143_aJ() <= 0.0f) {
            float f11 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f13 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f14 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f11, this.field_70163_u + 2.0 + (double)f13, this.field_70161_v + (double)f14, 0.0, 0.0, 0.0, new int[0]);
        } else {
            this.updateDragonEnderCrystal();
            float f10 = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            this.field_70988_bD = this.field_70994_bF ? (this.field_70988_bD += f10 * 0.5f) : (this.field_70988_bD += (f10 *= (float)Math.pow(2.0, this.field_70181_x)));
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.func_175446_cd()) {
                this.field_70988_bD = 0.5f;
            } else {
                if (this.field_70976_f < 0) {
                    for (int i = 0; i < this.field_70979_e.length; ++i) {
                        this.field_70979_e[i][0] = this.field_70177_z;
                        this.field_70979_e[i][1] = this.field_70163_u;
                    }
                }
                if (++this.field_70976_f == this.field_70979_e.length) {
                    this.field_70976_f = 0;
                }
                this.field_70979_e[this.field_70976_f][0] = this.field_70177_z;
                this.field_70979_e[this.field_70976_f][1] = this.field_70163_u;
                if (this.field_70170_p.field_72995_K) {
                    if (this.field_70716_bi > 0) {
                        double d5 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                        double d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                        double d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                        double d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                        this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                        this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                        --this.field_70716_bi;
                        this.func_70107_b(d5, d0, d1);
                        this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    }
                } else {
                    double d11 = this.targetX - this.field_70165_t;
                    double d12 = this.targetY - this.field_70163_u;
                    double d13 = this.targetZ - this.field_70161_v;
                    double d14 = d11 * d11 + d12 * d12 + d13 * d13;
                    if (this.target != null) {
                        this.targetX = this.target.field_70165_t;
                        this.targetZ = this.target.field_70161_v;
                        double d3 = this.targetX - this.field_70165_t;
                        double d5 = this.targetZ - this.field_70161_v;
                        double d7 = Math.sqrt(d3 * d3 + d5 * d5);
                        double d8 = (double)0.4f + d7 / 80.0 - 1.0;
                        if (d8 > 10.0) {
                            d8 = 10.0;
                        }
                        this.targetY = this.target.func_174813_aQ().field_72338_b + d8;
                    } else {
                        this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                        this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
                    }
                    if (this.forceNewTarget || d14 < 100.0 || d14 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                        this.setNewTarget();
                    }
                    d12 /= (double)MathHelper.func_76133_a((double)(d11 * d11 + d13 * d13));
                    float f17 = 0.6f;
                    d12 = MathHelper.func_151237_a((double)d12, (double)(-f17), (double)f17);
                    this.field_70181_x += d12 * (double)0.1f;
                    this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                    double d4 = 180.0 - MathHelper.func_181159_b((double)d11, (double)d13) * 180.0 / Math.PI;
                    double d6 = MathHelper.func_76138_g((double)(d4 - (double)this.field_70177_z));
                    if (d6 > 50.0) {
                        d6 = 50.0;
                    }
                    if (d6 < -50.0) {
                        d6 = -50.0;
                    }
                    Vec3d vec3 = new Vec3d(this.targetX - this.field_70165_t, this.targetY - this.field_70163_u, this.targetZ - this.field_70161_v).func_72432_b();
                    double d15 = -MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    Vec3d vec31 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), this.field_70181_x, d15).func_72432_b();
                    float f5 = ((float)vec31.func_72430_b(vec3) + 0.5f) / 1.5f;
                    if (f5 < 0.0f) {
                        f5 = 0.0f;
                    }
                    this.field_70704_bt *= 0.8f;
                    float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
                    double d9 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
                    if (d9 > 40.0) {
                        d9 = 40.0;
                    }
                    this.field_70704_bt = (float)((double)this.field_70704_bt + d6 * ((double)0.7f / d9 / (double)f6));
                    this.field_70177_z += this.field_70704_bt * 0.1f;
                    float f7 = (float)(2.0 / (d9 + 1.0));
                    float f8 = 0.06f;
                    this.func_191958_b(0.0f, 0.0f, -1.0f, 0.06f * (f7 * f8 + (1.0f - f8)));
                    if (this.field_70994_bF) {
                        this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)0.8f, this.field_70181_x * (double)0.8f, this.field_70179_y * (double)0.8f);
                    } else {
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    }
                    Vec3d vec32 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
                    float f9 = ((float)vec32.func_72430_b(vec31) + 1.0f) / 2.0f;
                    f9 = 0.8f + 0.15f * f9;
                    this.field_70159_w *= (double)f9;
                    this.field_70179_y *= (double)f9;
                    this.field_70181_x *= (double)0.91f;
                }
                this.field_70761_aq = this.field_70177_z;
                this.field_70986_h.field_70131_O = 3.0f;
                this.field_70986_h.field_70130_N = 3.0f;
                this.field_70985_j.field_70131_O = 2.0f;
                this.field_70985_j.field_70130_N = 2.0f;
                this.field_70984_by.field_70131_O = 2.0f;
                this.field_70984_by.field_70130_N = 2.0f;
                this.field_70982_bz.field_70131_O = 2.0f;
                this.field_70982_bz.field_70130_N = 2.0f;
                this.field_70987_i.field_70131_O = 3.0f;
                this.field_70987_i.field_70130_N = 5.0f;
                this.field_70983_bA.field_70131_O = 2.0f;
                this.field_70983_bA.field_70130_N = 4.0f;
                this.field_70990_bB.field_70131_O = 3.0f;
                this.field_70990_bB.field_70130_N = 4.0f;
                float f12 = (float)(this.func_70974_a(5, 1.0f)[1] - this.func_70974_a(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
                float f2 = MathHelper.func_76134_b((float)f12);
                float f15 = -MathHelper.func_76126_a((float)f12);
                float f3 = this.field_70177_z * (float)Math.PI / 180.0f;
                float f16 = MathHelper.func_76126_a((float)f3);
                float f4 = MathHelper.func_76134_b((float)f3);
                this.field_70987_i.func_70071_h_();
                this.field_70987_i.func_70012_b(this.field_70165_t + (double)(f16 * 0.5f), this.field_70163_u, this.field_70161_v - (double)(f4 * 0.5f), 0.0f, 0.0f);
                this.field_70983_bA.func_70071_h_();
                this.field_70983_bA.func_70012_b(this.field_70165_t + (double)(f4 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(f16 * 4.5f), 0.0f, 0.0f);
                this.field_70990_bB.func_70071_h_();
                this.field_70990_bB.func_70012_b(this.field_70165_t - (double)(f4 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(f16 * 4.5f), 0.0f, 0.0f);
                if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.field_70983_bA.func_174813_aQ().func_72321_a(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
                    this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.field_70990_bB.func_174813_aQ().func_72321_a(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
                    this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.field_70986_h.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0)));
                    this.BreathAttack();
                }
                double[] adouble1 = this.func_70974_a(5, 1.0f);
                double[] adouble = this.func_70974_a(0, 1.0f);
                float f18 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
                float f19 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
                this.field_70986_h.func_70071_h_();
                this.field_70986_h.func_70012_b(this.field_70165_t + (double)(f18 * 5.5f * f2), this.field_70163_u + (adouble[1] - adouble1[1]) * 1.0 + (double)(f15 * 5.5f), this.field_70161_v - (double)(f19 * 5.5f * f2), 0.0f, 0.0f);
                for (int j = 0; j < 3; ++j) {
                    MultiPartEntityPart entitydragonpart = null;
                    if (j == 0) {
                        entitydragonpart = this.field_70985_j;
                    }
                    if (j == 1) {
                        entitydragonpart = this.field_70984_by;
                    }
                    if (j == 2) {
                        entitydragonpart = this.field_70982_bz;
                    }
                    double[] adouble2 = this.func_70974_a(12 + j * 2, 1.0f);
                    float f20 = this.field_70177_z * (float)Math.PI / 180.0f + this.simplifyAngle(adouble2[0] - adouble1[0]) * (float)Math.PI / 180.0f * 1.0f;
                    float f21 = MathHelper.func_76126_a((float)f20);
                    float f22 = MathHelper.func_76134_b((float)f20);
                    float f23 = 1.5f;
                    float f24 = (float)(j + 1) * 2.0f;
                    entitydragonpart.func_70071_h_();
                    entitydragonpart.func_70012_b(this.field_70165_t - (double)((f16 * f23 + f21 * f24) * f2), this.field_70163_u + (adouble2[1] - adouble1[1]) * 1.0 - (double)((f24 + f23) * f15) + 1.5, this.field_70161_v + (double)((f4 * f23 + f22 * f24) * f2), 0.0f, 0.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70994_bF = this.getRidden() != null && this.getRidden() instanceof EntityRider ? ((EntityRider)this.getRidden()).riderAbilityBlocksinAABB(this.field_70986_h.func_174813_aQ()) | ((EntityRider)this.getRidden()).riderAbilityBlocksinAABB(this.field_70987_i.func_174813_aQ()) : this.destroyBlocksInAABB(this.field_70986_h.func_174813_aQ()) | this.destroyBlocksInAABB(this.field_70987_i.func_174813_aQ());
                    if (this.field_184676_bI != null) {
                        this.field_184676_bI.func_186099_b((EntityDragon)this);
                    }
                }
                if (this.getRidden() != null && this.getRidden() instanceof EntityRider) {
                    ((EntityRider)this.getRidden()).riderSpecial(this.target);
                }
            }
        }
    }

    private void updateDragonEnderCrystal() {
        if (this.field_70992_bH != null) {
            if (this.field_70992_bH.field_70128_L) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70965_a(this.field_70986_h, DamageSource.func_94539_a((Explosion)null), 10.0f);
                }
                this.field_70992_bH = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            float f = 32.0f;
            List list = this.field_70170_p.func_72872_a(EntityEnderCrystal.class, this.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.func_70068_e((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.field_70992_bH = entityendercrystal;
        }
    }

    private void collideWithEntities(List<Entity> p_70970_1_) {
        double d0 = (this.field_70987_i.func_174813_aQ().field_72340_a + this.field_70987_i.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.field_70987_i.func_174813_aQ().field_72339_c + this.field_70987_i.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (!(entity instanceof EntityLivingBase) || entity.getEntityData() != null && entity.getEntityData().func_74764_b("dragonSpawn")) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
        }
    }

    private void attackEntitiesInList(List<Entity> p_70971_1_) {
        for (int i = 0; i < p_70971_1_.size(); ++i) {
            Entity entity = p_70971_1_.get(i);
            if (!(entity instanceof EntityLivingBase) || entity.getEntityData() != null && entity.getEntityData().func_74764_b("dragonSpawn")) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
            this.func_174815_a((EntityLivingBase)this, entity);
        }
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (part != this.field_70986_h) {
            damage = damage / 4.0f + Math.min(damage, 1.0f);
        }
        if (damage < 0.01f) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer || source.func_94541_c()) {
            float f = this.func_110143_aJ();
            this.func_82195_e(source, damage);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
        Iterator iterator = list.iterator();
        boolean flag2 = false;
        while (iterator.hasNext()) {
            if (!((EntityPlayer)iterator.next()).func_175149_v()) continue;
            iterator.remove();
        }
        if (this.field_70146_Z.nextInt(2) == 0 && !list.isEmpty()) {
            this.target = (Entity)list.get(this.field_70146_Z.nextInt(list.size()));
        } else {
            boolean flag;
            do {
                this.targetX = 0.0;
                this.targetY = (float)ConfigHandler.dragonPortalY + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetZ = 0.0;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 30.0f - 15.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 30.0f - 15.0f);
                double d0 = this.field_70165_t - this.targetX;
                double d1 = this.field_70163_u - this.targetY;
                double d2 = this.field_70161_v - this.targetZ;
                flag = d0 * d0 + d1 * d1 + d2 * d2 > 100.0;
                EntityPlayer closestPlayer = this.field_70170_p.func_72890_a((Entity)this, 300.0);
                double distance = 0.0;
                if (closestPlayer == null || !((distance = closestPlayer.func_70011_f(this.targetX, this.targetY, this.targetZ)) > 100.0)) continue;
                this.target = closestPlayer;
                flag2 = true;
                break;
            } while (!flag);
            if (!flag2) {
                this.target = null;
            }
        }
    }

    private float simplifyAngle(double p_70973_1_) {
        return (float)MathHelper.func_76138_g((double)p_70973_1_);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    if (block.isAir(blockstate, (IBlockAccess)this.field_70170_p, blockpos)) continue;
                    if (this.canDragonDestroyBlock(block) && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(blockpos) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 18) {
            AxisAlignedBB p_70972_1_ = this.field_70987_i.func_174813_aQ();
            double d0 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d1 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_184134_a(d0, d1, d2, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 1.0f, 1.0f, true);
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean canDragonDestroyBlock(Block block) {
        if (this.getRidden() != null && this.getRidden() instanceof EntityRider) {
            return block != Blocks.field_180401_cv && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db && !block.hasTileEntity(block.func_176223_P());
        }
        return block != Blocks.field_180401_cv && block != Blocks.field_150343_Z && block != Blocks.field_150357_h && block != Blocks.field_150377_bs && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db && !block.hasTileEntity(block.func_176223_P());
    }

    public void func_174812_G() {
        this.func_70106_y();
        if (this.field_184676_bI != null) {
            this.field_184676_bI.func_186099_b((EntityDragon)this);
            this.field_184676_bI.func_186096_a((EntityDragon)this);
        } else if (this.bossInfo != null) {
            this.bossInfo.func_186758_d(false);
        }
    }

    protected void func_70609_aI() {
        if (this.field_184676_bI != null) {
            this.field_184676_bI.func_186099_b((EntityDragon)this);
        } else if (this.bossInfo != null) {
            this.bossInfo.func_186735_a(0.0f);
            this.bossInfo.func_186758_d(false);
        }
        ++this.field_70995_bG;
        if (this.field_70995_bG >= 180 && this.field_70995_bG <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70995_bG > 150 && this.field_70995_bG % 5 == 0 && flag) {
                int k;
                for (int i = 1000; i > 0; i -= k) {
                    k = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, k));
                }
            }
            if (this.field_70995_bG == 1) {
                this.field_70170_p.func_175669_a(1018, new BlockPos((Entity)this), 0);
            }
        }
        this.func_70091_d(MoverType.SELF, 0.0, 0.1f, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.field_70995_bG == 200 && !this.field_70170_p.field_72995_K) {
            if (flag) {
                int l;
                for (int j = 2000; j > 0; j -= l) {
                    l = EntityXPOrb.func_70527_a((int)j);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, l));
                }
            }
            if (this.field_184676_bI != null) {
                this.field_184676_bI.func_186096_a((EntityDragon)this);
            } else if (this.field_70170_p.field_73011_w instanceof WorldProviderEnd) {
                this.generatePortal(new BlockPos(this.field_70165_t, (double)ConfigHandler.dragonPortalY, this.field_70161_v));
            }
            this.func_70106_y();
        }
    }

    public void generatePortal(BlockPos pos) {
        int i = 4;
        double d0 = 12.25;
        double d1 = 6.25;
        for (int j = -1; j <= 32; ++j) {
            for (int k = -4; k <= 4; ++k) {
                for (int l = -4; l <= 4; ++l) {
                    double d2 = k * k + l * l;
                    if (!(d2 <= 12.25)) continue;
                    BlockPos blockpos = pos.func_177982_a(k, j, l);
                    if (j < 0) {
                        if (!(d2 <= 6.25)) continue;
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (j > 0) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (d2 > 6.25) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    this.field_70170_p.func_175656_a(blockpos, Blocks.field_150384_bq.func_176223_P());
                }
            }
        }
        this.field_70170_p.func_175656_a(pos, Blocks.field_150357_h.func_176223_P());
        this.field_70170_p.func_175656_a(pos.func_177984_a(), Blocks.field_150357_h.func_176223_P());
        BlockPos blockpos1 = pos.func_177981_b(2);
        this.field_70170_p.func_175656_a(blockpos1, Blocks.field_150357_h.func_176223_P());
        this.field_70170_p.func_175656_a(blockpos1.func_177976_e(), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST));
        this.field_70170_p.func_175656_a(blockpos1.func_177974_f(), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST));
        this.field_70170_p.func_175656_a(blockpos1.func_177978_c(), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
        this.field_70170_p.func_175656_a(blockpos1.func_177968_d(), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
        this.field_70170_p.func_175656_a(pos.func_177981_b(3), Blocks.field_150357_h.func_176223_P());
        if (ConfigHandler.dropLootChest) {
            this.field_70170_p.func_175656_a(pos.func_177981_b(4), Blocks.field_150486_ae.func_176223_P());
            EntityDragonOG.generateDragonLoot(this.field_70170_p, (TileEntityChest)this.field_70170_p.func_175625_s(pos.func_177981_b(4)));
        } else {
            this.field_70170_p.func_175656_a(pos.func_177981_b(4), Blocks.field_150380_bt.func_176223_P());
        }
    }

    public static void generateDragonLoot(World world, TileEntityChest chest) {
        int totalsize = chest.func_70302_i_();
        int index = 0;
        for (Loot l : LootRegisty.getConstantDrops(LootRegisty.dragonLoot)) {
            if (index >= totalsize) continue;
            chest.func_70299_a(index, l.getItemStack());
            ++index;
        }
        int dropcnt = 0;
        for (int i = index; i < totalsize && dropcnt != ConfigHandler.maxLootDrop; ++i) {
            ItemStack stack;
            Loot loot;
            if (!(world.field_73012_v.nextFloat() <= ConfigHandler.slotPrecentage) || (loot = LootRegisty.getRandom(world.field_73012_v, LootRegisty.dragonLoot)) == null || (stack = loot.getItemStack().func_77946_l()) == null) continue;
            chest.func_70299_a(i, stack);
            ++dropcnt;
        }
    }

    public static boolean canEntityChange(IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block != Blocks.field_180401_cv && block != Blocks.field_150343_Z && (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityRider || block != Blocks.field_150377_bs) && block != Blocks.field_150357_h && block != Blocks.field_150483_bI;
        }
        return true;
    }

    protected void func_70623_bb() {
    }

    public Entity[] func_70021_al() {
        return this.field_70977_g;
    }

    public boolean func_70067_L() {
        return false;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187526_aP;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void BreathAttack() {
        ++this.field_188664_b;
        if (this.field_188664_b > this.nextBreathAttack) {
            this.nextBreathAttack = this.field_70170_p.field_73012_v.nextInt(200) + 201;
            this.field_188664_b = 0;
            this.targetHit = false;
        } else if (this.field_188664_b == 10) {
            Vec3d vec3d = new Vec3d(this.field_70986_h.field_70165_t - this.field_70165_t, 0.0, this.field_70986_h.field_70161_v - this.field_70161_v).func_72432_b();
            float f = 5.0f;
            double d0 = this.field_70986_h.field_70165_t + vec3d.field_72450_a * (double)f / 2.0;
            double d1 = this.field_70986_h.field_70161_v + vec3d.field_72449_c * (double)f / 2.0;
            double d2 = this.field_70986_h.field_70163_u + (double)(this.field_70986_h.field_70131_O / 2.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)d0), MathHelper.func_76128_c((double)d2), MathHelper.func_76128_c((double)d1));
            if (this.target != null && this.target instanceof EntityPlayer) {
                d0 = MathHelper.func_76128_c((double)(this.target.field_70165_t + (double)this.field_70146_Z.nextInt(8)));
                d2 = this.target.field_70163_u - 1.0;
                d1 = MathHelper.func_76128_c((double)(this.target.field_70161_v + (double)this.field_70146_Z.nextInt(8)));
                this.targetHit = true;
            } else {
                while (this.field_70170_p.func_175623_d((BlockPos)blockpos$mutableblockpos) && d2 >= 1.0) {
                    blockpos$mutableblockpos.func_181079_c(MathHelper.func_76128_c((double)d0), MathHelper.func_76128_c((double)(d2 -= 1.0)), MathHelper.func_76128_c((double)d1));
                }
                if (d2 > 1.0) {
                    this.targetHit = true;
                }
            }
            if (this.targetHit) {
                d2 = MathHelper.func_76128_c((double)d2) + 1;
                this.areaEffectCloud = this.getBreathType(new EntityAreaEffectCloud(this.field_70170_p, d0, d2, d1), f);
                this.field_70170_p.func_72838_d((Entity)this.areaEffectCloud);
                this.targetHit = false;
            }
        }
    }

    public EntityAreaEffectCloud getBreathType(EntityAreaEffectCloud entityAreaEffectCloud, float f) {
        if (this.getRidden() != null && this.getRidden() instanceof EntityRider) {
            entityAreaEffectCloud = ((EntityRider)this.getRidden()).ridersBreathAttack(entityAreaEffectCloud, f);
        } else {
            entityAreaEffectCloud.func_184481_a((EntityLivingBase)this);
            entityAreaEffectCloud.func_184483_a(f);
            entityAreaEffectCloud.func_184486_b(200);
            entityAreaEffectCloud.func_184491_a(EnumParticleTypes.DRAGON_BREATH);
            entityAreaEffectCloud.func_184496_a(new PotionEffect(MobEffects.field_76433_i));
        }
        return entityAreaEffectCloud;
    }
}

