/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.ogdragon.entity.dragonRiders;

import com.gendeathrow.ogdragon.entity.EntityDragonOG;
import com.gendeathrow.ogdragon.entity.dragonRiders.EntityRiderRegistry;
import com.gendeathrow.ogdragon.entity.dragonRiders.RiderPowerBase;
import com.mojang.authlib.GameProfile;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRider
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<String> RIDER_VARIANT = EntityDataManager.func_187226_a(EntityRider.class, (DataSerializer)DataSerializers.field_187194_d);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.2, false);
    protected int specialTicks;
    public static ResourceLocation SKIN_RES_LOC = null;
    public String ridername = "Dragon Rider";
    public RiderPowerBase riderAbility;
    public GameProfile profile;

    public EntityRider(World worldIn) {
        super(worldIn);
        if (worldIn != null && !worldIn.field_72995_K) {
            this.setCombatTask();
        }
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public void setProfile(GameProfile updateProfile) {
        this.profile = updateProfile;
        this.updateRaiderVariant(updateProfile.getName());
    }

    public void updateRaiderVariant(String name) {
        this.field_70180_af.func_187227_b(RIDER_VARIANT, (Object)name);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && RIDER_VARIANT.equals(key)) {
            this.setProfile(new GameProfile(null, (String)this.field_70180_af.func_187225_a(RIDER_VARIANT)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSkin() {
        return SKIN_RES_LOC;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIDER_VARIANT, (Object)"null");
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187800_eb;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.func_70105_a(0.72f, 2.535f);
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityDragonOG && ((EntityDragonOG)this.func_184187_bx()).getRidden() == null) {
            ((EntityDragonOG)this.func_184187_bx()).setRidden((Entity)this);
        }
        super.func_70636_d();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderHell && this.func_70681_au().nextInt(5) > 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        }
        String ridersName = EntityRiderRegistry.getRandomRiderName(this.field_70170_p);
        this.func_96094_a(ridersName);
        this.setProfile(new GameProfile(null, ridersName));
        try {
            this.setRiderPower(EntityRiderRegistry.getPower(ridersName, this));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.func_98053_h(false);
        return livingdata;
    }

    public void setCombatTask() {
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        entityarrow.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0) {
            entityarrow.func_70015_d(100);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("RiderType", 99)) {
            byte by = tagCompund.func_74771_c("RiderType");
        }
        this.setCombatTask();
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public RiderPowerBase getRiderPower() {
        return this.riderAbility;
    }

    public void setRiderPower(RiderPowerBase newPower) {
        this.riderAbility = newPower;
    }

    public boolean riderAbilityBlocksinAABB(AxisAlignedBB p_70972_1_) {
        if (this.getRiderPower() != null) {
            return this.getRiderPower().riderAbilityBlocksinAABB(p_70972_1_);
        }
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    if (block.isAir(blockstate, (IBlockAccess)this.field_70170_p, blockpos)) continue;
                    if (block.canEntityDestroy(blockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(blockpos) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d0 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d1 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public void saveJson(FileWriter fw) {
    }

    public void riderSpecial(Entity target) {
        if (this.getRiderPower() != null) {
            this.getRiderPower().riderSpecial(target);
        }
    }

    public EntityAreaEffectCloud ridersBreathAttack(EntityAreaEffectCloud entityAreaEffectCloud, float f) {
        if (this.getRiderPower() != null) {
            return this.getRiderPower().ridersBreathAttack(entityAreaEffectCloud, f);
        }
        entityAreaEffectCloud.func_184481_a((EntityLivingBase)this);
        entityAreaEffectCloud.func_184483_a(f);
        entityAreaEffectCloud.func_184486_b(200);
        entityAreaEffectCloud.func_184491_a(EnumParticleTypes.DRAGON_BREATH);
        entityAreaEffectCloud.func_184496_a(new PotionEffect(MobEffects.field_76433_i));
        return entityAreaEffectCloud;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_184187_bx() != null ? false : super.func_70097_a(source, amount);
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

