/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.ogdragon.utils;

import com.gendeathrow.ogdragon.core.OGDragon;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class Loot {
    public int weight = 10;
    public String item = "minecraft:apple";
    int meta = 0;
    public ItemStack stack;
    public int stackSize = 1;
    public int minStackSize = 1;
    public NBTTagCompound nbtData = null;
    public boolean alwaysDrop = false;

    public Loot() {
    }

    public Loot(JsonObject json) {
        this.readFromJson(json);
    }

    public Loot(Item obj) {
        this.stack = new ItemStack(obj);
    }

    public ItemStack getItemStack() {
        Item i = Item.func_111206_d((String)this.item);
        if (i == null) {
            return null;
        }
        int dropSize = 1;
        if (this.stackSize != this.minStackSize) {
            dropSize = new Random().nextInt(this.stackSize - this.minStackSize) + this.minStackSize + 1;
            if (dropSize < 1) {
                dropSize = 1;
            } else if (dropSize > this.stackSize) {
                dropSize = this.stackSize;
            }
        } else {
            dropSize = this.stackSize;
        }
        this.stack = new ItemStack(i, dropSize, this.meta);
        if (this.nbtData != null) {
            if (this.stack.func_77942_o()) {
                this.stack.func_77978_p().func_179237_a(this.nbtData);
            } else {
                this.stack.func_77982_d(this.nbtData);
            }
        }
        return this.stack;
    }

    public boolean readFromJson(JsonObject json) {
        int stackSize = 1;
        if (json.has("item")) {
            this.item = json.get("item").getAsString();
        }
        if (json.has("weight")) {
            this.weight = json.get("weight").getAsInt();
        }
        if (this.weight <= -1) {
            this.alwaysDrop = true;
        }
        if (json.has("meta")) {
            this.meta = json.get("meta").getAsInt();
        }
        if (json.has("stackSize")) {
            try {
                this.minStackSize = stackSize = json.get("stackSize").getAsInt();
            }
            catch (Throwable e) {
                try {
                    String parse = json.get("stackSize").getAsString();
                    String[] split = parse.split("~");
                    this.minStackSize = Integer.parseInt(split[0]);
                    stackSize = Integer.parseInt(split[1]);
                }
                catch (Throwable e1) {
                    OGDragon.logger.log(Level.ERROR, "Could not parse Loot Item. Setting Default");
                    stackSize = 1;
                    this.minStackSize = 1;
                }
            }
        }
        try {
            this.nbtData = json.has("nbt") ? JsonToNBT.func_180713_a((String)json.get("nbt").getAsJsonObject().toString()) : null;
        }
        catch (NBTException e) {
            e.printStackTrace();
            this.nbtData = null;
        }
        Item i = Item.func_111206_d((String)this.item);
        if (stackSize > 1) {
            this.stackSize = stackSize;
        }
        if (stackSize < 1) {
            this.stackSize = 1;
        } else if (stackSize > 64) {
            this.stackSize = 64;
        }
        return i != null;
    }
}

