/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.ogdragon.utils;

import com.gendeathrow.ogdragon.core.OGDragon;
import com.gendeathrow.ogdragon.utils.Loot;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.Level;

public class LootRegisty {
    public static ArrayList<Loot> dragonLoot = new ArrayList();

    public static Loot getRandom(Random rand, ArrayList<Loot> list) {
        int total = LootRegisty.getTotalWeight(list);
        float r = rand.nextFloat() * (float)total;
        int cnt = 0;
        for (Loot entry : list) {
            if (entry.alwaysDrop || !((float)(cnt += entry.weight) >= r)) continue;
            return entry;
        }
        return null;
    }

    public static ArrayList<Loot> getConstantDrops(ArrayList<Loot> list) {
        ArrayList<Loot> dropList = new ArrayList<Loot>();
        for (Loot entry : list) {
            if (!entry.alwaysDrop) continue;
            dropList.add(entry);
        }
        return dropList;
    }

    public static int getTotalWeight(ArrayList<Loot> list) {
        int total = 0;
        for (Loot l : list) {
            total += l.weight;
        }
        return total;
    }

    public static void LoadDragonLoot(File f) {
        JsonObject lootArrayJson = LootRegisty.ReadJsonFile(f);
        for (Map.Entry lootJson : lootArrayJson.entrySet()) {
            if (((String)lootJson.getKey()).toLowerCase().trim().equals("_comment")) continue;
            Loot loot = new Loot();
            JsonObject lootobject = ((JsonElement)lootJson.getValue()).getAsJsonObject();
            if (loot.readFromJson(lootobject)) {
                dragonLoot.add(loot);
                continue;
            }
            OGDragon.logger.log(Level.ERROR, "[OGDragon loot registry] Item not loaded: " + lootobject.toString());
        }
        OGDragon.logger.log(Level.INFO, "Loaded loot:" + dragonLoot.size());
    }

    private static JsonObject ReadJsonFile(File f) {
        try {
            FileReader fr = new FileReader(f);
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return json;
        }
        catch (Exception e) {
            OGDragon.logger.log(Level.ERROR, "An error occured while loading JSON from file:", (Throwable)e);
            return new JsonObject();
        }
    }
}

