/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="simpletomb")
@Config(modid="simpletomb", name="simpletomb", category="")
public class ConfigTomb {
    @Config.Name(value="simpletomb")
    public static final ConfigTomb INSTANCE = new ConfigTomb();
    @Config.Name(value="tomb.enabled")
    @Config.Comment(value={"Whether to handle player death at all (false will disable almost the entire mod such as spawning the grave on death)"})
    public boolean handlePlayerDeath = true;
    @Config.Name(value="tomb.log_message")
    @Config.Comment(value={"Whether to log the positions of players' graves to game (server) console"})
    public boolean logPlayerGrave = true;
    @Config.Name(value="tomb.extra_items")
    @Config.Comment(value={"The radius in which extra items should be hunted for and collected when a grave is spawned; set to zero (0) to disable"})
    @Config.RangeInt(min=0, max=8)
    public int pickUpGroundRange = 2;
    @Config.Name(value="key.given")
    @Config.Comment(value={"Whether to give a Grave Key item to the player on death.  Grave can be opened without they key, but the key will help the player locate the grave"})
    public boolean graveKeyOnDeath = true;
    @Config.Name(value="key.named")
    @Config.Comment(value={"If a key is being dropped, will the player's display name be added to the tomb key item name"})
    public boolean addNameToPlayersKey = true;
    @Config.Name(value="teleport.survival")
    @Config.Comment(value={"When survival player is within this (straight line calculated) distance from the tomb, they can teleport to the tomb.  Set as zero (0) to disable survival TP feature.  Set as negative one (-1) to allow survival teleportation always and ignore the distance (within dimension)  "})
    @Config.RangeInt(min=1, max=64)
    public int distanceUntilTpSurvival = 16;
    @Config.Name(value="teleport.creative")
    @Config.Comment(value={"If creative players can teleport to the tomb with the key, ignoring distance"})
    public boolean tpToGraveCreative = true;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("simpletomb")) {
            ConfigManager.sync((String)"simpletomb", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

