/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityTomb
extends TileEntity
implements ITickable {
    protected final ItemStackHandler inventory = new ItemStackHandler(120);
    protected String ownerName = "";
    protected long deathDate;
    public int timer = 0;
    protected UUID ownerId = null;
    private boolean onlyOwnersAccess = true;

    public void giveInventory(@Nullable EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && player != null && !(player instanceof FakePlayer)) {
            for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                if (!EntityHelper.autoequip(this.inventory.getStackInSlot(i), player)) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            IntStream.range(0, this.inventory.getSlots()).forEach(ix -> {
                ItemStack stack = this.inventory.getStackInSlot(ix);
                if (!stack.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack.func_77946_l());
                    this.inventory.setStackInSlot(ix, ItemStack.field_190927_a);
                }
            });
            this.removeGraveBy(player);
            player.field_71069_bz.func_75142_b();
            MessageType.MESSAGE_OPEN_GRAVE_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
        }
    }

    public boolean onlyOwnersCanAccess() {
        return this.onlyOwnersAccess;
    }

    private void removeGraveBy(@Nullable EntityPlayer player) {
        if (this.field_145850_b != null) {
            WorldHelper.removeNoEvent(this.field_145850_b, this.field_174879_c);
            if (player != null) {
                this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void initTombstoneOwner(EntityPlayer owner) {
        this.deathDate = System.currentTimeMillis();
        this.ownerName = owner.func_145748_c_().func_150260_c();
        this.ownerId = owner.func_110124_au();
    }

    public boolean isOwner(EntityPlayer owner) {
        if (this.ownerId == null || owner == null || !this.hasOwner()) {
            return false;
        }
        return this.ownerId.equals(owner.func_110124_au());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtension = 1.0;
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtension, (double)this.field_174879_c.func_177956_o() - renderExtension, (double)this.field_174879_c.func_177952_p() - renderExtension, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtension, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtension, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtension);
    }

    public void func_73660_a() {
        if (this.func_145838_q() instanceof BlockTomb) {
            ++this.timer;
            if (this.field_145850_b.field_72995_K) {
                if (WorldHelper.atInterval(this.timer, 100)) {
                    ModTomb.PROXY.produceGraveSoul(this.field_145850_b, this.field_174879_c);
                }
                ModTomb.PROXY.produceGraveSmoke(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    String getOwnerName() {
        return this.ownerName;
    }

    boolean hasOwner() {
        return this.ownerName.length() > 0;
    }

    long getOwnerDeathTime() {
        return this.deathDate;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74768_a("countTicks", this.timer);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.ownerId != null) {
            compound.func_186854_a("ownerid", this.ownerId);
        }
        compound.func_74757_a("onlyOwnersAccess", this.onlyOwnersAccess);
        super.func_189515_b(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.ownerName = compound.func_74779_i("ownerName");
        this.deathDate = compound.func_74763_f("deathDate");
        this.timer = compound.func_74762_e("countTicks");
        if (compound.func_150297_b("inventory", 10)) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_186855_b("ownerid")) {
            this.ownerId = compound.func_186857_a("ownerid");
        }
        this.onlyOwnersAccess = compound.func_74767_n("onlyOwnersAccess");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = this.func_189515_b(new NBTTagCompound());
        if (nbt.func_150297_b("inventory", 10)) {
            nbt.func_82580_o("inventory");
        }
        return nbt;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_145842_c(int id, int type) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(facing == null ? this.inventory : null);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockTomb) {
                return;
            }
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.extractItem(i, stack.func_190916_E(), false));
            }
        }
        super.func_145843_s();
    }
}

