/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.data;

import com.google.common.base.MoreObjects;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LocationBlockPos {
    public int x;
    public int y;
    public int z;
    public int dim;
    public static final BlockPos ORIGIN_POS = new BlockPos(0, Integer.MIN_VALUE, 0);
    public static final LocationBlockPos ORIGIN = new LocationBlockPos(ORIGIN_POS, Integer.MIN_VALUE);

    public LocationBlockPos(BlockPos pos, int dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public LocationBlockPos(BlockPos pos, World world) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73011_w.getDimension());
    }

    public LocationBlockPos(int x, int y, int z, int dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public LocationBlockPos(Entity entity) {
        this(entity.func_180425_c(), entity.field_70170_p);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(LocationBlockPos loc) {
        return loc.x == this.x && loc.y == this.y && loc.z == this.z && loc.dim == this.dim;
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public double getDistance(BlockPos pos) {
        double deltX = this.x - pos.func_177958_n();
        double deltY = this.y - pos.func_177956_o();
        double deltZ = this.z - pos.func_177952_p();
        return Math.sqrt(deltX * deltX + deltY * deltY + deltZ * deltZ);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", this.dim).toString();
    }
}

