/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityHelper {
    public static final String NBT_PLAYER_PERSISTED = "PlayerPersisted";

    public static boolean autoequip(ItemStack stack, EntityPlayer player) {
        ResourceLocation registryName = stack.func_77973_b().getRegistryName();
        if (!stack.func_190926_b() && registryName != null) {
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack) > 0) {
                return false;
            }
            if (stack.func_77976_d() == 1) {
                if (player.func_184592_cb().func_190926_b() && stack.func_77973_b().isShield(stack, (EntityLivingBase)player) && player.func_174820_d(99, stack.func_77946_l())) {
                    return true;
                }
                EntityEquipmentSlot slot = stack.func_77973_b().getEquipmentSlot(stack);
                boolean isElytra = false;
                if (slot == null) {
                    if (stack.func_77973_b() instanceof ItemArmor) {
                        slot = ((ItemArmor)stack.func_77973_b()).field_77881_a;
                    } else {
                        if (!(stack.func_77973_b() instanceof ItemElytra)) {
                            return false;
                        }
                        slot = EntityEquipmentSlot.CHEST;
                        isElytra = true;
                    }
                } else if (slot == EntityEquipmentSlot.CHEST) {
                    isElytra = stack.func_77973_b() instanceof ItemElytra;
                }
                int slotId = slot.func_188454_b();
                ItemStack stackInSlot = (ItemStack)player.field_71071_by.field_70460_b.get(slotId);
                if (stackInSlot.func_190926_b()) {
                    player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
                    return true;
                }
                if (slot != EntityEquipmentSlot.CHEST) {
                    return false;
                }
                if (isElytra) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackInSlot.func_77946_l());
                    player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof EntityPlayer && !(entity instanceof FakePlayer);
    }

    public static boolean isValidPlayerMP(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static NBTTagCompound getPersistentTag(EntityPlayer player) {
        NBTTagCompound persistentData = player.getEntityData();
        if (persistentData.func_74764_b(NBT_PLAYER_PERSISTED)) {
            NBTTagCompound persistentTag = (NBTTagCompound)persistentData.func_74781_a(NBT_PLAYER_PERSISTED);
            return persistentTag;
        }
        NBTTagCompound persistentTag = new NBTTagCompound();
        persistentData.func_74782_a(NBT_PLAYER_PERSISTED, (NBTBase)persistentTag);
        return persistentTag;
    }
}

