/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.data.LocationBlockPos;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.common.DimensionManager;

public class WorldHelper {
    public static LocationBlockPos findGraveSpawn(EntityPlayer player, BlockPos initPos) {
        int xRange = 8;
        int yRange = 7;
        int zRange = 8;
        Iterable it = BlockPos.func_177980_a((BlockPos)new BlockPos(initPos.func_177958_n() - xRange, initPos.func_177956_o() - yRange, initPos.func_177952_p() - zRange), (BlockPos)new BlockPos(initPos.func_177958_n() + xRange, initPos.func_177956_o() + yRange, initPos.func_177952_p() + zRange));
        List positions = StreamSupport.stream(it.spliterator(), false).collect(Collectors.toList());
        positions.sort((pos0, pos1) -> {
            double dist0 = pos0.func_177954_c((double)initPos.func_177958_n(), (double)initPos.func_177956_o(), (double)initPos.func_177952_p());
            double dist1 = pos1.func_177954_c((double)initPos.func_177958_n(), (double)initPos.func_177956_o(), (double)initPos.func_177952_p());
            return Double.compare(dist0, dist1);
        });
        for (BlockPos pos : positions) {
            if (player.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) continue;
            return new LocationBlockPos(pos, player.field_71093_bK);
        }
        return null;
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return ticksExisted > 0L && ticksExisted % (long)tick == 0L;
    }

    public static int getRandom(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(Random random, double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !world.func_189509_E(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = Math.max(Math.min(pos.func_177956_o(), world.field_73011_w.getActualHeight()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !world.func_189509_E(pos);
    }

    public static boolean isValidDimension(int dim) {
        return WorldHelper.getDimensionIds().contains(dim);
    }

    private static List<Integer> getDimensionIds() {
        return Arrays.asList(DimensionManager.getStaticDimensionIDs());
    }

    public static boolean isRuleKeepInventory(EntityPlayer player) {
        return WorldHelper.isRuleKeepInventory(player.field_70170_p);
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_82766_b("keepInventory");
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        WorldHelper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 3);
    }

    public static boolean isNight(World world) {
        float angle = world.func_72826_c(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static float[] getRGBColor3F(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

