/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.dave.pipemaster.base.CommandBaseExt;

public abstract class CommandBaseMenu
extends CommandBaseExt {
    private List<CommandBaseExt> subcommands = new ArrayList<CommandBaseExt>();
    private List<String> commands = new ArrayList<String>();

    public CommandBaseMenu() {
        this.initEntries();
    }

    public abstract void initEntries();

    public void addSubcommand(CommandBaseExt subcommand) {
        if (subcommand.getParentCommand() != null) {
            return;
        }
        subcommand.setParentCommand(this);
        this.subcommands.add(subcommand);
        this.commands.add(subcommand.func_71517_b());
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean found = false;
        if (args.length > 0) {
            for (CommandBaseExt cmd : this.subcommands) {
                if (!cmd.func_71517_b().equalsIgnoreCase(args[0])) continue;
                found = true;
                if (!cmd.func_184882_a(server, sender)) continue;
                String[] remaining = Arrays.copyOfRange(args, 1, args.length);
                cmd.func_184881_a(server, sender, remaining);
                return;
            }
        }
        if (found) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.pipemaster.denied", new Object[0]));
            return;
        }
        if (args.length == 0 || !found) {
            TextComponentTranslation tc = new TextComponentTranslation("commands.pipemaster.available", new Object[0]);
            tc.func_150256_b().func_150228_d(Boolean.valueOf(true));
            tc.func_150258_a("\n");
            for (CommandBaseExt cmd : this.subcommands) {
                boolean allowed = cmd.func_184882_a(server, sender);
                String color = "" + (allowed ? TextFormatting.GREEN : TextFormatting.DARK_RED);
                tc.func_150257_a((ITextComponent)new TextComponentString("\n" + color + cmd.func_71517_b() + " "));
                TextComponentTranslation tt = new TextComponentTranslation(cmd.getCommandDescription(sender), new Object[0]);
                tt.func_150256_b().func_150238_a(TextFormatting.GRAY);
                tt.func_150256_b().func_150228_d(Boolean.valueOf(false));
                tc.func_150257_a((ITextComponent)tt);
                tc.func_150257_a((ITextComponent)new TextComponentString("" + TextFormatting.RESET));
            }
            sender.func_145747_a((ITextComponent)tc);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandBaseMenu.func_175762_a((String[])args, this.commands);
        }
        if (args.length > 1) {
            for (CommandBase commandBase : this.subcommands) {
                if (!commandBase.func_71517_b().equalsIgnoreCase(args[0]) || !commandBase.func_184882_a(server, sender)) continue;
                String[] remaining = Arrays.copyOfRange(args, 1, args.length);
                return commandBase.func_184883_a(server, sender, remaining, pos);
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

