/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.data.blockgroups;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import org.dave.pipemaster.items.goggles.EnumBoxOptimizationStrategy;

public class BlockGroup {
    private String id;
    private ItemStack itemIcon;
    private String translationKey;
    private HashSet<IBlockState> validStates;
    private EnumBoxOptimizationStrategy optimizationStrategy;
    private String modId;

    public BlockGroup(String id) {
        this.id = id;
        this.validStates = new HashSet();
        this.optimizationStrategy = EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES;
    }

    public BlockGroup setItemIcon(ItemStack itemIcon) {
        this.itemIcon = itemIcon;
        return this;
    }

    public BlockGroup setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    public BlockGroup setOptimizationStrategy(EnumBoxOptimizationStrategy optimizationStrategy) {
        this.optimizationStrategy = optimizationStrategy;
        return this;
    }

    public EnumBoxOptimizationStrategy getOptimizationStrategy() {
        return this.optimizationStrategy;
    }

    public String getModId() {
        return this.modId;
    }

    public BlockGroup setModId(String modId) {
        this.modId = modId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public ItemStack getItemIcon() {
        return this.itemIcon;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean containsBlockState(IBlockState state) {
        return this.validStates.contains(state.func_177230_c().func_176223_P());
    }

    public BlockGroup setValidBlockStates(List<IBlockState> blocks) {
        this.validStates.addAll(blocks);
        return this;
    }

    public String toString() {
        return String.format("BlockGroup[id=%s]", this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockGroup that = (BlockGroup)o;
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }
}

