/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.data.blockgroups;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dave.pipemaster.data.blockgroups.BlockGroup;
import org.dave.pipemaster.data.config.ConfigurationHandler;
import org.dave.pipemaster.util.Logz;
import org.dave.pipemaster.util.MultiIndexMap;
import org.dave.pipemaster.util.ResourceLoader;
import org.dave.pipemaster.util.SerializationHelper;

public class BlockGroupRegistry {
    private MultiIndexMap<BlockGroup> groupMap;
    private BlockGroup emptyBlockGroup = new BlockGroup("disabled");

    public BlockGroupRegistry() {
        this.reloadGroups();
    }

    public void reloadGroups() {
        this.groupMap = new MultiIndexMap();
        this.groupMap.addIndex(MapCategories.GROUP_ID, String.class, BlockGroup::getId);
        this.groupMap.addIndex(MapCategories.MOD_ID, String.class, BlockGroup::getModId);
        this.groupMap.add(this.emptyBlockGroup);
        ResourceLoader loader = new ResourceLoader(ConfigurationHandler.blockGroupsDirectory, "assets/pipemaster/config/blockgroups/");
        for (Map.Entry<String, InputStream> entry : loader.getResources().entrySet()) {
            String filename = entry.getKey();
            InputStream is = entry.getValue();
            if (!filename.endsWith(".json")) continue;
            Logz.info(" > Loading blockgroups from file: '%s'", filename);
            try {
                List blockGroups = (List)SerializationHelper.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), new TypeToken<List<BlockGroup>>(){}.getType());
                for (BlockGroup group : blockGroups) {
                    Logz.info(" + %s", group.getId());
                    this.groupMap.add(group);
                }
            }
            catch (JsonParseException e) {
                Logz.info("Could not load blockgroups from file '%s': %s", filename, e.getLocalizedMessage());
            }
        }
    }

    public Collection<BlockGroup> getBlockGroups() {
        return this.groupMap.values();
    }

    public Set<String> getGroupIds() {
        return this.groupMap.keySet(String.class, MapCategories.GROUP_ID);
    }

    public BlockGroup getEmptyBlockGroup() {
        return this.emptyBlockGroup;
    }

    public BlockGroup getBlockGroupById(String id) {
        if (!this.groupMap.contains(MapCategories.GROUP_ID, id)) {
            return this.emptyBlockGroup;
        }
        return this.groupMap.getFirstElement(MapCategories.GROUP_ID, id);
    }

    public BlockGroup getBlockGroupByModId(String modId) {
        if (!this.groupMap.contains(MapCategories.MOD_ID, modId)) {
            return this.emptyBlockGroup;
        }
        return this.groupMap.getFirstElement(MapCategories.MOD_ID, modId);
    }

    static enum MapCategories implements MultiIndexMap.IEnumCategory
    {
        MOD_ID,
        GROUP_ID;

    }
}

