/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.data.blockgroups;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.dave.pipemaster.data.blockgroups.BlockGroup;
import org.dave.pipemaster.items.goggles.EnumBoxOptimizationStrategy;
import org.dave.pipemaster.util.Logz;

public class BlockGroupSerializer
implements JsonDeserializer<List<BlockGroup>> {
    public List<BlockGroup> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject() && !json.isJsonArray()) {
            throw new JsonParseException("Root structure is neither an object nor an array.");
        }
        ArrayList<BlockGroup> result = new ArrayList<BlockGroup>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                result.add(this.deserializeBlockGroup(element));
            }
        } else if (json.isJsonObject()) {
            result.add(this.deserializeBlockGroup(json));
        }
        return result;
    }

    private ItemStack deserializeItemStack(JsonElement element) throws JsonParseException {
        String itemName;
        int meta = 0;
        int count = 1;
        if (element.isJsonObject()) {
            JsonObject data = element.getAsJsonObject();
            if (!data.has("name")) {
                throw new JsonParseException("ItemStack section is missing 'name' property.");
            }
            itemName = data.get("name").getAsString();
            meta = data.has("meta") ? data.get("meta").getAsInt() : 0;
            count = data.has("count") ? data.get("count").getAsInt() : 1;
        } else {
            itemName = element.getAsString();
        }
        ResourceLocation resource = new ResourceLocation(itemName);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resource);
        if (item == null) {
            throw new JsonParseException("Could not find item with name " + itemName);
        }
        ItemStack result = new ItemStack(item, count, meta);
        return result;
    }

    private IBlockState deserializeBlockState(JsonElement element) throws JsonParseException {
        String blockName;
        int meta = 0;
        if (element.isJsonObject()) {
            JsonObject data = element.getAsJsonObject();
            if (!data.has("name")) {
                Logz.warn("Invalid block in blockgroup configuration! Skipping: %s", element);
                return null;
            }
            blockName = data.get("name").getAsString();
            meta = data.has("meta") ? data.get("meta").getAsInt() : 0;
        } else {
            blockName = element.getAsString();
        }
        ResourceLocation resource = new ResourceLocation(blockName);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resource);
        if (block == null || block == Blocks.field_150350_a) {
            throw new JsonParseException("Could not find block with name: " + blockName);
        }
        return block.func_176223_P();
    }

    private BlockGroup deserializeBlockGroup(JsonElement root) throws JsonParseException {
        if (!root.isJsonObject()) {
            throw new JsonParseException("Expected BlockGroup element, but found no object");
        }
        JsonObject rootObj = root.getAsJsonObject();
        if (!rootObj.has("id")) {
            throw new JsonParseException("Missing 'id' in block group definition");
        }
        String groupId = rootObj.get("id").getAsString();
        if (!rootObj.has("mod")) {
            throw new JsonParseException("Missing 'mod' in block group definition");
        }
        String requiredMod = rootObj.get("mod").getAsString();
        if (requiredMod.length() <= 0) {
            throw new JsonParseException("Value for 'mod' in block group definition is empty");
        }
        if (!Loader.isModLoaded((String)requiredMod)) {
            throw new JsonParseException("Mod '" + requiredMod + "' for block group '" + groupId + "' is not loaded. Skipping integration!");
        }
        if (!rootObj.has("itemIcon")) {
            throw new JsonParseException("Missing 'itemIcon' property in block group definition");
        }
        ItemStack itemIcon = this.deserializeItemStack(rootObj.get("itemIcon"));
        if (!rootObj.has("translationKey")) {
            throw new JsonParseException("Missing 'translationKey' in block group definition");
        }
        String translationKey = rootObj.get("translationKey").getAsString();
        if (!rootObj.has("blocks")) {
            throw new JsonParseException("Missing 'blocks' array in block group definition");
        }
        if (!rootObj.get("blocks").isJsonArray()) {
            throw new JsonParseException("Property 'blocks' in block group definition is no array");
        }
        ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
        for (JsonElement element : rootObj.getAsJsonArray("blocks")) {
            IBlockState state = this.deserializeBlockState(element);
            if (state == null) continue;
            blocks.add(state);
        }
        EnumBoxOptimizationStrategy optimizationStrategy = EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES;
        if (rootObj.has("optimizationStrategy")) {
            try {
                optimizationStrategy = EnumBoxOptimizationStrategy.valueOf(rootObj.get("optimizationStrategy").getAsString());
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Invalid value for optimizationStrategy property.");
            }
        }
        BlockGroup result = new BlockGroup(groupId);
        result.setOptimizationStrategy(optimizationStrategy);
        result.setItemIcon(itemIcon);
        result.setTranslationKey(translationKey);
        result.setValidBlockStates(blocks);
        result.setModId(requiredMod);
        return result;
    }
}

