/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import org.dave.pipemaster.gui.GUI;
import org.dave.pipemaster.gui.event.KeyTypedEvent;
import org.dave.pipemaster.gui.event.MouseClickEvent;
import org.dave.pipemaster.gui.event.MouseMoveEvent;
import org.dave.pipemaster.gui.event.UpdateScreenEvent;
import org.dave.pipemaster.gui.event.WidgetEventResult;

public abstract class WidgetGuiContainer
extends GuiContainer {
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;

    public WidgetGuiContainer(Container container) {
        super(container);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.gui.fireEvent(new UpdateScreenEvent());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.gui.fireEvent(new KeyTypedEvent(typedChar, keyCode)) == WidgetEventResult.CONTINUE_PROCESSING) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.gui.fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.gui.fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        RenderHelper.func_74520_c();
        this.gui.drawTooltips((GuiScreen)this, mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
        RenderHelper.func_74518_a();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.gui.drawGUI((GuiScreen)this);
        if (this.field_147002_h != null && this.field_147002_h.field_75151_b != null) {
            for (Slot slot : this.field_147002_h.field_75151_b) {
                this.gui.drawSlot((GuiScreen)this, slot, this.field_147003_i, this.field_147009_r);
            }
        }
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }
}

