/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.gui.widgets;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import org.dave.pipemaster.gui.event.IWidgetListener;
import org.dave.pipemaster.gui.event.KeyTypedEvent;
import org.dave.pipemaster.gui.event.MouseClickEvent;
import org.dave.pipemaster.gui.event.UpdateScreenEvent;
import org.dave.pipemaster.gui.event.WidgetEventResult;
import org.dave.pipemaster.gui.widgets.Widget;
import org.dave.pipemaster.gui.widgets.WidgetWithValue;
import org.dave.pipemaster.util.Logz;

public class WidgetInputField
extends WidgetWithValue<String> {
    public String text = "";
    public String placeholder = "";
    private int maxStringLength = 32;
    private int cursorCounter;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private Predicate<String> validator = Predicates.alwaysTrue();
    int placeholderColor = 0x33FFFFFF;
    int textColor = -1;
    int disabledTextColor = -9408400;
    int backgroundColor = -13421773;
    int borderColor = -16777216;
    int updateTicks = 0;

    public WidgetInputField(String fieldIdentifier) {
        this.setId("InputField[" + fieldIdentifier + "]");
        this.addListener(MouseClickEvent.class, new IWidgetListener<MouseClickEvent>(){

            @Override
            public WidgetEventResult call(MouseClickEvent event, Widget widget) {
                Logz.info("Mouse clicked @ x=%d, y=%d", event.x, event.y);
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
        });
        this.addListener(UpdateScreenEvent.class, new IWidgetListener<UpdateScreenEvent>(){

            @Override
            public WidgetEventResult call(UpdateScreenEvent event, Widget widget) {
                ++((WidgetInputField)widget).updateTicks;
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
        });
        this.addListener(KeyTypedEvent.class, new IWidgetListener<KeyTypedEvent>(){

            @Override
            public WidgetEventResult call(KeyTypedEvent event, Widget widget) {
                WidgetInputField self = (WidgetInputField)widget;
                if (!self.focused) {
                    return WidgetEventResult.CONTINUE_PROCESSING;
                }
                if (GuiScreen.func_175278_g((int)event.keyCode)) {
                    self.setCursorPositionEnd();
                    self.setSelectionPos(0);
                    return WidgetEventResult.HANDLED;
                }
                if (GuiScreen.func_175280_f((int)event.keyCode)) {
                    GuiScreen.func_146275_d((String)self.getSelectedText());
                    return WidgetEventResult.HANDLED;
                }
                if (GuiScreen.func_175279_e((int)event.keyCode)) {
                    if (self.enabled) {
                        self.writeText(GuiScreen.func_146277_j());
                    }
                    return WidgetEventResult.HANDLED;
                }
                if (GuiScreen.func_175277_d((int)event.keyCode)) {
                    GuiScreen.func_146275_d((String)self.getSelectedText());
                    if (self.enabled) {
                        self.writeText("");
                    }
                    return WidgetEventResult.HANDLED;
                }
                switch (event.keyCode) {
                    case 14: {
                        if (GuiScreen.func_146271_m()) {
                            if (self.enabled) {
                                self.deleteWords(-1);
                            }
                        } else if (self.enabled) {
                            self.deleteFromCursor(-1);
                        }
                        return WidgetEventResult.HANDLED;
                    }
                    case 199: {
                        if (GuiScreen.func_146272_n()) {
                            self.setSelectionPos(0);
                        } else {
                            self.setCursorPositionZero();
                        }
                        return WidgetEventResult.HANDLED;
                    }
                    case 203: {
                        if (GuiScreen.func_146272_n()) {
                            if (GuiScreen.func_146271_m()) {
                                self.setSelectionPos(self.getNthWordFromPos(-1, self.getSelectionEnd()));
                            } else {
                                self.setSelectionPos(self.getSelectionEnd() - 1);
                            }
                        } else if (GuiScreen.func_146271_m()) {
                            self.setCursorPosition(self.getNthWordFromCursor(-1));
                        } else {
                            self.moveCursorBy(-1);
                        }
                        return WidgetEventResult.HANDLED;
                    }
                    case 205: {
                        if (GuiScreen.func_146272_n()) {
                            if (GuiScreen.func_146271_m()) {
                                self.setSelectionPos(self.getNthWordFromPos(1, self.getSelectionEnd()));
                            } else {
                                self.setSelectionPos(self.getSelectionEnd() + 1);
                            }
                        } else if (GuiScreen.func_146271_m()) {
                            self.setCursorPosition(self.getNthWordFromCursor(1));
                        } else {
                            self.moveCursorBy(1);
                        }
                        return WidgetEventResult.HANDLED;
                    }
                    case 207: {
                        if (GuiScreen.func_146272_n()) {
                            self.setSelectionPos(self.text.length());
                        } else {
                            self.setCursorPositionEnd();
                        }
                        return WidgetEventResult.HANDLED;
                    }
                    case 211: {
                        if (GuiScreen.func_146271_m()) {
                            if (self.enabled) {
                                self.deleteWords(1);
                            }
                        } else if (self.enabled) {
                            self.deleteFromCursor(1);
                        }
                        return WidgetEventResult.HANDLED;
                    }
                }
                if (ChatAllowedCharacters.func_71566_a((char)event.typedChar)) {
                    if (self.enabled) {
                        self.writeText(Character.toString(event.typedChar));
                    }
                    return WidgetEventResult.HANDLED;
                }
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
        });
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setText(String textIn) {
        if (this.validator.apply((Object)textIn)) {
            String oldText = this.text;
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.valueChanged(oldText, this.text);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void setValidator(Predicate<String> theValidator) {
        this.validator = theValidator;
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = ChatAllowedCharacters.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        if (this.validator.apply((Object)s)) {
            String oldText = this.text;
            this.text = s;
            this.moveCursorBy(i - this.selectionEnd + l);
            this.valueChanged(oldText, s);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                String s = "";
                if (i >= 0) {
                    s = this.text.substring(0, i);
                }
                if (j < this.text.length()) {
                    s = s + this.text.substring(j);
                }
                if (this.validator.apply((Object)s)) {
                    this.text = s;
                    if (flag) {
                        this.moveCursorBy(num);
                    }
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.selectionEnd + num);
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int i = this.text.length();
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
        }
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setDisabledTextColour(int color) {
        this.disabledTextColor = color;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getWidth() {
        return this.width;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        if (position > i) {
            position = i;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        if (fr != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getWidth();
            String s = fr.func_78269_a(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (position == this.lineScrollOffset) {
                this.lineScrollOffset -= fr.func_78262_a(this.text, j, true).length();
            }
            if (position > k) {
                this.lineScrollOffset += position - k;
            } else if (position <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - position;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    @Override
    public void draw(GuiScreen screen) {
        super.draw(screen);
        int x = 0;
        int y = 0;
        int width = this.width;
        int height = this.height;
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)this.borderColor);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)this.backgroundColor);
        if (!this.focused && this.placeholder.length() > 0 && this.text.isEmpty()) {
            GlStateManager.func_179147_l();
            screen.field_146297_k.field_71466_p.func_78279_b(this.placeholder, x + 3, y + 6, width - 2, this.placeholderColor);
            return;
        }
        int i = this.enabled ? this.textColor : this.disabledTextColor;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = screen.field_146297_k.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.focused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = x + 4;
        int i1 = y + (height - 8) / 2;
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = screen.field_146297_k.field_71466_p.func_175063_a(s1, (float)l, (float)i1, i);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.width : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            j1 = screen.field_146297_k.field_71466_p.func_175063_a(s.substring(j), (float)j1, (float)i1, i);
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + screen.field_146297_k.field_71466_p.field_78288_b), (int)-3092272);
            } else {
                screen.field_146297_k.field_71466_p.func_175063_a("_", (float)k1, (float)i1, i);
            }
        }
        if (k != j) {
            int l1 = l + screen.field_146297_k.field_71466_p.func_78256_a(s.substring(0, k));
            this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + screen.field_146297_k.field_71466_p.field_78288_b);
        }
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }
}

