/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.gui.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.dave.pipemaster.gui.event.MouseClickEvent;
import org.dave.pipemaster.gui.event.TabChangedEvent;
import org.dave.pipemaster.gui.event.WidgetEventResult;
import org.dave.pipemaster.gui.widgets.Widget;
import org.dave.pipemaster.gui.widgets.WidgetPanel;

public class WidgetTabsPanel
extends WidgetPanel {
    private List<WidgetPanel> pages = new ArrayList<WidgetPanel>();
    private Map<WidgetPanel, ItemStack> pageStacks = new HashMap<WidgetPanel, ItemStack>();
    private Map<WidgetPanel, List<String>> pageTooltips = new HashMap<WidgetPanel, List<String>>();
    private WidgetPanel activePanel = null;

    public void addPage(WidgetPanel panel, ItemStack buttonStack) {
        this.addPage(panel, buttonStack, null);
    }

    public void addPage(WidgetPanel panel, ItemStack buttonStack, List<String> tooltip) {
        this.pages.add(panel);
        this.pageStacks.put(panel, buttonStack);
        if (this.activePanel == null) {
            this.activePanel = panel;
        } else {
            panel.setVisible(false);
        }
        if (tooltip != null) {
            this.pageTooltips.put(panel, tooltip);
        }
        this.add(panel);
    }

    public void setActivePage(int page) {
        if (page < 0 || page >= this.pages.size()) {
            return;
        }
        this.activePanel.setVisible(false);
        this.pages.get(page).setVisible(true);
        WidgetPanel tmpOld = this.activePanel;
        this.activePanel = this.pages.get(page);
        this.fireEvent(new TabChangedEvent(tmpOld, this.pages.get(page)));
    }

    public WidgetPanel getButtonsPanel() {
        WidgetPanel result = new WidgetPanel();
        int y = 0;
        for (WidgetPanel page : this.pages) {
            WidgetTabsButton button = new WidgetTabsButton(this, page, this.pageStacks.get(page));
            button.setX(0);
            button.setY(y);
            button.setWidth(32);
            button.setHeight(28);
            result.add(button);
            if (this.pageTooltips.containsKey(page)) {
                button.addTooltipLine(this.pageTooltips.get(page));
            }
            y += 28;
        }
        return result;
    }

    private static class WidgetTabsButton
    extends Widget {
        private static ResourceLocation tabIcons = new ResourceLocation("pipemaster", "textures/gui/tabicons.png");
        WidgetTabsPanel parent;
        WidgetPanel page;
        ItemStack pageStack;

        public WidgetTabsButton(WidgetTabsPanel parent, WidgetPanel page, ItemStack pageStack) {
            this.parent = parent;
            this.page = page;
            this.pageStack = pageStack;
            this.addListener(MouseClickEvent.class, (event, widget) -> {
                this.setActive(true);
                return WidgetEventResult.HANDLED;
            });
        }

        public void setActive(boolean fireEvent) {
            this.parent.activePanel.setVisible(false);
            this.page.setVisible(true);
            WidgetPanel tmpOld = this.parent.activePanel;
            this.parent.activePanel = this.page;
            if (fireEvent) {
                this.parent.fireEvent(new TabChangedEvent(tmpOld, this.page));
            }
        }

        private boolean isActive() {
            return this.parent.activePanel == this.page;
        }

        private boolean isFirst() {
            return this.parent.pages.indexOf(this.page) == 0;
        }

        @Override
        public void draw(GuiScreen screen) {
            GlStateManager.func_179094_E();
            screen.field_146297_k.func_110434_K().func_110577_a(tabIcons);
            GlStateManager.func_179140_f();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            int buttonWidth = 32;
            if (!this.isActive()) {
                buttonWidth = 28;
            }
            int textureY = this.isFirst() ? 28 : 56;
            screen.func_73729_b(4, 0, this.isActive() ? 32 : 0, textureY, buttonWidth, 28);
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(this.pageStack, 12, 5);
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }
    }
}

