/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.gui.widgets;

import java.util.Collection;
import org.dave.pipemaster.gui.CircularPointedArrayList;
import org.dave.pipemaster.gui.event.MouseClickEvent;
import org.dave.pipemaster.gui.event.ValueChangedEvent;
import org.dave.pipemaster.gui.event.WidgetEventResult;
import org.dave.pipemaster.gui.widgets.Widget;

public class WidgetWithChoiceValue<T>
extends Widget {
    CircularPointedArrayList<T> choices = new CircularPointedArrayList();

    public T getValue() {
        return this.choices.getPointedElement();
    }

    public void setValue(T choice) {
        T oldValue = this.choices.getPointedElement();
        this.choices.setPointerTo(choice);
        T newValue = this.choices.getPointedElement();
        this.fireEvent(new ValueChangedEvent<T>(oldValue, newValue));
    }

    public void addChoice(T ... newChoices) {
        for (T newChoice : newChoices) {
            this.choices.add(newChoice);
        }
    }

    public void addChoiceFromArray(T[] newChoices) {
        for (T newChoice : newChoices) {
            this.choices.add(newChoice);
        }
    }

    public void addChoice(Collection<T> newChoices) {
        this.choices.addAll(newChoices);
    }

    public void next() {
        T oldValue = this.choices.getPointedElement();
        T newValue = this.choices.next();
        this.fireEvent(new ValueChangedEvent<T>(oldValue, newValue));
    }

    public void prev() {
        T oldValue = this.choices.getPointedElement();
        T newValue = this.choices.prev();
        this.fireEvent(new ValueChangedEvent<T>(oldValue, newValue));
    }

    public void addClickListener() {
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            if (event.isLeftClick()) {
                ((WidgetWithChoiceValue)widget).next();
            } else {
                ((WidgetWithChoiceValue)widget).prev();
            }
            return WidgetEventResult.HANDLED;
        });
    }
}

