/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.items.goggles;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.dave.pipemaster.data.blockgroups.BlockGroup;
import org.dave.pipemaster.data.config.ConfigurationHandler;
import org.dave.pipemaster.items.goggles.BoxRenderer;
import org.dave.pipemaster.items.goggles.EnumBoxOptimizationStrategy;
import org.dave.pipemaster.items.goggles.PipeGogglesConfigOptions;
import org.dave.pipemaster.items.goggles.PipeGogglesData;
import org.dave.pipemaster.util.WorldTools;

public class BoxOptimizer {
    Set<Line> lines = new DeletingHashSet<Line>();
    int channelId;
    long lastUpdateTick = Long.MIN_VALUE;
    Color color = Color.RED;

    public BoxOptimizer(int channelId) {
        this.channelId = channelId;
    }

    public void eventuallyUpdate(EntityPlayer player, EnumHand hand, PipeGogglesData data) {
        boolean lastUpdateTickIsInThePast;
        World world = player.field_70170_p;
        boolean cacheIsCurrent = this.lastUpdateTick + (long)PipeGogglesConfigOptions.cacheTTL >= world.func_82737_E();
        boolean hasLines = this.lines.size() > 0;
        boolean bl = lastUpdateTickIsInThePast = this.lastUpdateTick <= world.func_82737_E();
        if (cacheIsCurrent && hasLines && lastUpdateTickIsInThePast) {
            return;
        }
        BlockPos base = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        BlockPos min = base.func_177982_a(-data.getRange(), -data.getRange(), -data.getRange());
        BlockPos max = base.func_177982_a(data.getRange(), data.getRange(), data.getRange());
        BlockGroup group = data.getBlockGroupForSlot(this.channelId);
        this.lines = group.getOptimizationStrategy() == EnumBoxOptimizationStrategy.SKIP_DUPLICATE_LINES ? new HashSet<Line>() : new DeletingHashSet<Line>();
        WorldTools.foreachBlockBetween(min, max, pos -> {
            if (world.func_175623_d(pos)) {
                return;
            }
            IBlockState state = world.func_180495_p(pos);
            if (group.containsBlockState(state)) {
                ArrayList boxes = new ArrayList();
                world.func_180495_p(pos).func_185908_a(world, pos, new AxisAlignedBB(pos), boxes, null, false);
                boxes.forEach(box -> this.addBox((AxisAlignedBB)box));
            }
        });
        this.color = ConfigurationHandler.hex2Rgb(PipeGogglesConfigOptions.optimizerColorsHex[this.channelId]);
        this.lastUpdateTick = world.func_82737_E();
    }

    public void render(EntityPlayer player, float partialTicks) {
        BoxRenderer.renderLines(player, partialTicks, this.color, this.lines);
    }

    public void addBox(AxisAlignedBB box) {
        Vec3d topFrontLeft = new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f);
        Vec3d topFrontRight = new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72339_c);
        Vec3d topBackRight = new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72339_c);
        Vec3d topBackLeft = new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72334_f);
        Vec3d bottomBackRight = new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        Vec3d bottomBackLeft = new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72334_f);
        Vec3d bottomFrontLeft = new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72334_f);
        Vec3d bottomFrontRight = new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72339_c);
        this.lines.add(new Line(topFrontLeft, topFrontRight));
        this.lines.add(new Line(topFrontLeft, topBackLeft));
        this.lines.add(new Line(topFrontLeft, bottomFrontLeft));
        this.lines.add(new Line(bottomFrontRight, topFrontRight));
        this.lines.add(new Line(bottomFrontRight, bottomBackRight));
        this.lines.add(new Line(bottomFrontRight, bottomFrontLeft));
        this.lines.add(new Line(bottomBackLeft, topBackLeft));
        this.lines.add(new Line(bottomBackLeft, bottomBackRight));
        this.lines.add(new Line(bottomBackLeft, bottomFrontLeft));
        this.lines.add(new Line(topBackRight, topBackLeft));
        this.lines.add(new Line(topBackRight, topFrontRight));
        this.lines.add(new Line(topBackRight, bottomBackRight));
    }

    class Line
    extends TwoPointGeoObject {
        public Line(Vec3d start, Vec3d end) {
            super(start, end);
        }
    }

    class Square
    extends TwoPointGeoObject {
        public Square(Vec3d start, Vec3d end) {
            super(start, end);
        }
    }

    class TwoPointGeoObject {
        public Vec3d start;
        public Vec3d end;

        public TwoPointGeoObject(Vec3d start, Vec3d end) {
            Vec3d origin = new Vec3d(0.0, 0.0, 0.0);
            if (start.func_72438_d(origin) < end.func_72438_d(origin)) {
                this.start = start;
                this.end = end;
            } else {
                this.end = start;
                this.start = end;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwoPointGeoObject that = (TwoPointGeoObject)o;
            return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{start=" + this.start + ", end=" + this.end + '}';
        }
    }

    class DeletingHashSet<E>
    extends HashSet<E> {
        DeletingHashSet() {
        }

        @Override
        public boolean add(E e) {
            if (!this.contains(e)) {
                return super.add(e);
            }
            this.remove(e);
            return false;
        }
    }
}

