/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.items.goggles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import org.dave.pipemaster.PipeMaster;
import org.dave.pipemaster.data.blockgroups.BlockGroup;
import org.dave.pipemaster.init.Itemss;
import org.dave.pipemaster.items.goggles.PipeGogglesSlotConfiguration;

public class PipeGogglesData
implements INBTSerializable<NBTTagCompound> {
    List<PipeGogglesSlotConfiguration> slots = new ArrayList<PipeGogglesSlotConfiguration>();
    boolean enabled = true;
    long storedPower = 0L;
    int range = 4;

    public PipeGogglesData() {
        this.slots.add(0, new PipeGogglesSlotConfiguration("disabled"));
        this.slots.add(1, new PipeGogglesSlotConfiguration("disabled"));
        this.slots.add(2, new PipeGogglesSlotConfiguration("disabled"));
        this.slots.add(3, new PipeGogglesSlotConfiguration("disabled"));
    }

    public PipeGogglesData(NBTTagCompound nbt) {
        this();
        this.deserializeNBT(nbt);
    }

    public PipeGogglesData(ItemStack stack) {
        this();
        if (!stack.func_77942_o()) {
            return;
        }
        this.deserializeNBT(stack.func_77978_p());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PipeGogglesData setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PipeGogglesData toggleEnabled() {
        this.enabled = !this.enabled;
        return this;
    }

    public int getRange() {
        return this.range;
    }

    public PipeGogglesData setRange(int range) {
        this.range = range;
        return this;
    }

    public void setGroupForSlot(int slot, String group) {
        if (slot >= this.slots.size()) {
            return;
        }
        this.slots.set(slot, new PipeGogglesSlotConfiguration(group));
    }

    public BlockGroup getBlockGroupForSlot(int blockGroupIndex) {
        if (blockGroupIndex < 0 || blockGroupIndex >= this.slots.size()) {
            return PipeMaster.blockGroupRegistry.getEmptyBlockGroup();
        }
        return PipeMaster.blockGroupRegistry.getBlockGroupById(this.slots.get((int)blockGroupIndex).groupId);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74757_a("enabled", this.enabled);
        result.func_74772_a("storedRF", this.storedPower);
        result.func_74768_a("range", this.range);
        NBTTagList tagList = new NBTTagList();
        for (PipeGogglesSlotConfiguration slot : this.slots) {
            tagList.func_74742_a((NBTBase)slot.serializeNBT());
        }
        result.func_74782_a("slots", (NBTBase)tagList);
        return result;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.enabled = nbt.func_74767_n("enabled");
        this.storedPower = nbt.func_74763_f("storedRF");
        this.range = nbt.func_74762_e("range");
        this.slots.clear();
        for (NBTBase listElementBase : nbt.func_150295_c("slots", 10)) {
            NBTTagCompound listElementCompound = (NBTTagCompound)listElementBase;
            this.slots.add(new PipeGogglesSlotConfiguration(listElementCompound));
        }
    }

    public ItemStack createItemStack() {
        ItemStack result = new ItemStack((Item)Itemss.pipeGoggles, 1, 0);
        result.func_77982_d(this.serializeNBT());
        return result;
    }
}

