/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.items.goggles.gui;

import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.dave.pipemaster.data.blockgroups.BlockGroup;
import org.dave.pipemaster.data.config.ConfigurationHandler;
import org.dave.pipemaster.gui.GUI;
import org.dave.pipemaster.gui.WidgetGuiContainer;
import org.dave.pipemaster.gui.event.ValueChangedEvent;
import org.dave.pipemaster.gui.event.WidgetEventResult;
import org.dave.pipemaster.gui.widgets.WidgetSelectButton;
import org.dave.pipemaster.items.goggles.PipeGogglesConfigOptions;
import org.dave.pipemaster.items.goggles.PipeGogglesData;
import org.dave.pipemaster.items.goggles.gui.WidgetPipeGogglesBlockGroup;
import org.dave.pipemaster.items.goggles.network.PipeGogglesUpdateBlockGroupMessage;
import org.dave.pipemaster.items.goggles.network.PipeGogglesUpdateRangeMessage;
import org.dave.pipemaster.network.PipeMasterNetworkHandler;

public class PipeGogglesGuiContainer
extends WidgetGuiContainer {
    private PipeGogglesData gogglesData;
    private static final ResourceLocation background = new ResourceLocation("pipemaster", "textures/gui/pipe_goggles.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 183;
    private final int currentItemSlot;

    public PipeGogglesGuiContainer(Container container, PipeGogglesData gogglesData, int currentItemSlot) {
        super(container);
        this.field_146999_f = 190;
        this.field_147000_g = 183;
        this.gogglesData = gogglesData;
        this.currentItemSlot = currentItemSlot;
        this.gui = this.instantiateGui();
    }

    protected GUI instantiateGui() {
        GUI gui = new GUI(0, 0, 190, 183);
        gui.setId("gui");
        int yPadding = 3;
        int channelId = 0;
        while (channelId < 4) {
            WidgetPipeGogglesBlockGroup bgWidget = new WidgetPipeGogglesBlockGroup(ConfigurationHandler.hex2Rgb(PipeGogglesConfigOptions.optimizerColorsHex[channelId]), this.gogglesData.getBlockGroupForSlot(channelId));
            bgWidget.setX(5);
            bgWidget.setY(5 + channelId * (bgWidget.height + yPadding));
            int finalChannelId = channelId++;
            bgWidget.addListener(ValueChangedEvent.class, (event, widget) -> {
                PipeMasterNetworkHandler.instance.sendToServer((IMessage)new PipeGogglesUpdateBlockGroupMessage(this.currentItemSlot, finalChannelId, ((BlockGroup)event.newValue).getId()));
                return WidgetEventResult.HANDLED;
            });
            gui.add(bgWidget);
        }
        WidgetSelectButton<Object> rangeSelectButton = new WidgetSelectButton<Object>();
        rangeSelectButton.setWidth(25);
        rangeSelectButton.addChoice((Collection<Object>)PipeGogglesConfigOptions.validRanges);
        rangeSelectButton.setX(160);
        rangeSelectButton.setY(7);
        rangeSelectButton.addListener(ValueChangedEvent.class, (event, widget) -> {
            PipeMasterNetworkHandler.instance.sendToServer((IMessage)new PipeGogglesUpdateRangeMessage(this.currentItemSlot, (Integer)event.newValue));
            return WidgetEventResult.HANDLED;
        });
        rangeSelectButton.setValue(this.gogglesData.getRange());
        rangeSelectButton.setTooltipLines(I18n.func_135052_a((String)"pipemaster.pipegoggles.gui.range", (Object[])new Object[0]));
        gui.add(rangeSelectButton);
        return gui;
    }
}

