/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.items.goggles.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import org.dave.pipemaster.PipeMaster;
import org.dave.pipemaster.data.blockgroups.BlockGroup;
import org.dave.pipemaster.gui.event.MouseClickEvent;
import org.dave.pipemaster.gui.event.ValueChangedEvent;
import org.dave.pipemaster.gui.event.WidgetEventResult;
import org.dave.pipemaster.gui.widgets.WidgetColorDisplay;
import org.dave.pipemaster.gui.widgets.WidgetPanel;
import org.dave.pipemaster.gui.widgets.WidgetSelectButton;
import org.dave.pipemaster.gui.widgets.WidgetWithChoiceValue;

public class WidgetPipeGogglesBlockGroup
extends WidgetPanel {
    public WidgetPipeGogglesBlockGroup(Color color, BlockGroup initialGroup) {
        this.setWidth(160);
        this.setHeight(20);
        WidgetColorDisplay colorDisplay = new WidgetColorDisplay(color, color.darker().darker().darker(), false);
        colorDisplay.setX(2);
        colorDisplay.setY(6);
        colorDisplay.setWidth(11);
        colorDisplay.setHeight(11);
        this.add(colorDisplay);
        WidgetSelectButton<BlockGroup> groupSelectButton = new WidgetSelectButton<BlockGroup>(){

            @Override
            protected void drawButtonContent(GuiScreen screen, FontRenderer fontrenderer) {
                BlockGroup blockGroup = (BlockGroup)this.getValue();
                if (blockGroup.getId().equals("disabled")) {
                    screen.func_73732_a(fontrenderer, "-", this.width / 2, (this.height - 8) / 2, 0xEEEEEE);
                } else {
                    Minecraft.func_71410_x().func_175599_af().func_180450_b(((BlockGroup)this.getValue()).getItemIcon(), 2, 2);
                    screen.func_73731_b(fontrenderer, I18n.func_135052_a((String)((BlockGroup)this.getValue()).getTranslationKey(), (Object[])new Object[0]), 20, 6, 0xEEEEEE);
                }
                RenderHelper.func_74518_a();
            }

            @Override
            public void addClickListener() {
                this.addListener(MouseClickEvent.class, (event, widget) -> {
                    if (!event.carriedStack.func_190926_b()) {
                        String modId = event.carriedStack.func_77973_b().getRegistryName().func_110624_b();
                        BlockGroup selected = PipeMaster.blockGroupRegistry.getBlockGroupByModId(modId);
                        ((WidgetWithChoiceValue)widget).setValue(selected);
                    } else if (event.isLeftClick()) {
                        ((WidgetWithChoiceValue)widget).next();
                    } else {
                        ((WidgetWithChoiceValue)widget).prev();
                    }
                    return WidgetEventResult.HANDLED;
                });
            }
        };
        groupSelectButton.addChoice(PipeMaster.blockGroupRegistry.getBlockGroups());
        groupSelectButton.setWidth(135);
        groupSelectButton.setX(17);
        groupSelectButton.setY(2);
        groupSelectButton.setValue(initialGroup);
        this.addChildListener(ValueChangedEvent.class, groupSelectButton);
        this.add(groupSelectButton);
    }
}

