/*
 * Decompiled with CFR 0.152.
 */
package org.dave.pipemaster.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;

public class MultiIndexMap<V>
extends HashSet<V> {
    List<IndexerDefinition> indexers = new ArrayList<IndexerDefinition>();
    Map<IEnumCategory, Map<Object, Set<V>>> indices = new HashMap<IEnumCategory, Map<Object, Set<V>>>();
    int index = 0;

    public MultiIndexMap() {
        this.addIndex(EnumCategory.NUM, Integer.TYPE, v -> this.index++);
    }

    @Override
    public boolean add(V element) {
        boolean success = super.add(element);
        if (success) {
            for (IndexerDefinition indexer : this.indexers) {
                Object key = indexer.indexFunction.apply(element);
                if (key == null) continue;
                if (!this.indices.containsKey(indexer.categoryName)) {
                    this.indices.put(indexer.categoryName, new HashMap());
                }
                if (!this.indices.get(indexer.categoryName).containsKey(key)) {
                    this.indices.get(indexer.categoryName).put(key, new HashSet());
                }
                this.indices.get(indexer.categoryName).get(key).add(element);
            }
        }
        return success;
    }

    public V getRandomElement(Random rand) {
        int index = rand.nextInt(this.size());
        return this.getFirstElement(EnumCategory.NUM, index);
    }

    public Set<V> getElementsBy(IEnumCategory index, Object key) {
        if (!this.indices.containsKey(index)) {
            return Collections.emptySet();
        }
        if (!this.indices.get(index).containsKey(key)) {
            return Collections.emptySet();
        }
        return this.indices.get(index).get(key);
    }

    public V getFirstElement(IEnumCategory index, Object key) {
        return this.getElementsBy(index, key).stream().findFirst().orElse(null);
    }

    public <R> Set<R> keySet(Class<R> typeOfSet, IEnumCategory index) {
        if (!this.indices.containsKey(index)) {
            return Collections.emptySet();
        }
        return this.indices.get(index).keySet();
    }

    public Collection<V> values() {
        if (!this.indices.containsKey(EnumCategory.NUM)) {
            return Collections.emptySet();
        }
        HashSet<V> result = new HashSet<V>();
        for (Set<V> vals : this.indices.get(EnumCategory.NUM).values()) {
            result.addAll(vals);
        }
        return result;
    }

    public boolean contains(IEnumCategory index, Object key) {
        if (!this.indices.containsKey(index)) {
            return false;
        }
        return this.indices.get(index).containsKey(key);
    }

    public <T> void addIndex(IEnumCategory index, Class<T> type, Function<V, T> indexFunction) {
        this.indexers.add(new IndexerDefinition<V, T>(index, indexFunction));
    }

    public static enum EnumCategory implements IEnumCategory
    {
        NUM;

    }

    public static interface IEnumCategory {
    }

    private static class IndexerDefinition<V, T> {
        public IEnumCategory categoryName;
        public Function<V, T> indexFunction;

        public IndexerDefinition(IEnumCategory categoryName, Function<V, T> indexFunction) {
            this.categoryName = categoryName;
            this.indexFunction = indexFunction;
        }
    }
}

