/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.blocks.tiles;

import funwayguy.bdsandm.inventory.InventoryShipping;
import funwayguy.bdsandm.inventory.capability.ShippingProxyWrapper;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityShipping
extends TileEntity
implements IInventoryChangedListener,
ITickable {
    private int proxyIdx;
    private final InventoryShipping invo;
    private final ShippingProxyWrapper proxyWrapper;
    private static final EnumFacing[][] openSides = new EnumFacing[8][3];
    private int[] colors = new int[]{-1, -1, -1};

    public TileEntityShipping() {
        this(0);
    }

    public TileEntityShipping(int index) {
        this.proxyIdx = index & 7;
        this.invo = new InventoryShipping(this);
        this.proxyWrapper = new ShippingProxyWrapper(this, this.invo);
    }

    public int getColorCount() {
        return this.colors.length;
    }

    public int[] getColors() {
        return this.colors;
    }

    public void setColors(int[] c) {
        for (int i = 0; i < c.length && i < this.colors.length; ++i) {
            this.colors[i] = c[i];
        }
        this.func_70296_d();
        if (this.field_145850_b.func_73046_m() != null) {
            this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IEnergyStorage myEnergy = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null);
        if (myEnergy == null || myEnergy.getEnergyStored() <= 0 || !myEnergy.canExtract()) {
            return;
        }
        int maxOffer = myEnergy.extractEnergy(Integer.MAX_VALUE, true);
        if (maxOffer <= 0) {
            return;
        }
        int sent = 0;
        for (EnumFacing side : openSides[this.proxyIdx]) {
            IEnergyStorage target;
            BlockPos offPos = this.field_174879_c.func_177972_a(side);
            TileEntity tile = this.field_145850_b.func_175625_s(offPos);
            if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d()) || (target = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) == null || !target.canReceive()) continue;
            sent += target.receiveEnergy(maxOffer - sent, false);
        }
        myEnergy.extractEnergy(sent, false);
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        this.func_70296_d();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.getProxyTile() == null) {
            return false;
        }
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntityShipping proxyTile = this.getProxyTile();
        if (proxyTile == null) {
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)proxyTile.proxyWrapper);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)proxyTile.proxyWrapper);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)proxyTile.proxyWrapper);
        }
        return null;
    }

    @Nullable
    public InventoryShipping getContainerInvo() {
        TileEntityShipping proxyTile = this.getProxyTile();
        return proxyTile == null ? null : proxyTile.invo;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("proxyIdx", this.proxyIdx);
        tag.func_74783_a("objColors", this.colors);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.invo.func_70302_i_(); ++i) {
            ItemStack stack = this.invo.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("slot", (byte)i);
            itemTag.func_74782_a("item", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("invo", (NBTBase)list);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.proxyIdx = tag.func_74762_e("proxyIdx");
        this.colors = Arrays.copyOf(tag.func_74759_k("objColors"), this.colors.length);
        this.invo.func_174888_l();
        for (NBTBase nbt : tag.func_150295_c("invo", 10)) {
            if (!(nbt instanceof NBTTagCompound)) continue;
            NBTTagCompound itemTag = (NBTTagCompound)nbt;
            this.invo.setSlotWithoutNotice(itemTag.func_74771_c("slot"), new ItemStack(itemTag.func_74775_l("item")));
        }
        this.invo.func_70296_d();
    }

    @Nullable
    public TileEntityShipping getProxyTile() {
        TileEntityShipping proxyTile = this;
        if (this.proxyIdx != 0) {
            BlockPos startPos;
            switch (this.proxyIdx) {
                case 4: {
                    startPos = this.field_174879_c.func_177982_a(-1, 0, 0);
                    break;
                }
                case 5: {
                    startPos = this.field_174879_c.func_177982_a(-1, 0, -1);
                    break;
                }
                case 1: {
                    startPos = this.field_174879_c.func_177982_a(0, 0, -1);
                    break;
                }
                case 6: {
                    startPos = this.field_174879_c.func_177982_a(-1, -1, 0);
                    break;
                }
                case 7: {
                    startPos = this.field_174879_c.func_177982_a(-1, -1, -1);
                    break;
                }
                case 3: {
                    startPos = this.field_174879_c.func_177982_a(0, -1, -1);
                    break;
                }
                case 2: {
                    startPos = this.field_174879_c.func_177982_a(0, -1, 0);
                    break;
                }
                default: {
                    startPos = this.field_174879_c;
                }
            }
            if (!this.field_145850_b.func_175667_e(startPos)) {
                return null;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(startPos);
            if (!(tile instanceof TileEntityShipping)) {
                return null;
            }
            proxyTile = (TileEntityShipping)tile;
        }
        return proxyTile;
    }

    static {
        for (int i = 0; i < 8; ++i) {
            TileEntityShipping.openSides[i][0] = i == 0 || i == 1 || i == 4 || i == 5 ? EnumFacing.DOWN : EnumFacing.UP;
            TileEntityShipping.openSides[i][1] = i == 0 || i == 2 || i == 4 || i == 6 ? EnumFacing.NORTH : EnumFacing.SOUTH;
            TileEntityShipping.openSides[i][2] = i < 4 ? EnumFacing.WEST : EnumFacing.EAST;
        }
    }
}

