/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.inventory.capability;

import funwayguy.bdsandm.inventory.capability.BdsmCapabilies;
import funwayguy.bdsandm.inventory.capability.CapabilityBarrel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class CapabilityProviderBarrel
implements ICapabilityProvider,
ICapabilitySerializable<NBTTagCompound> {
    private final CapabilityBarrel barrel;
    private ItemStack stack;

    public CapabilityProviderBarrel(int initCap, int maxCap) {
        this.barrel = new CapabilityBarrel(initCap, maxCap);
    }

    public CapabilityProviderBarrel setParentStack(ItemStack stack) {
        this.stack = stack;
        this.barrel.setFluidContainer(stack);
        ItemStack finStack = stack;
        this.barrel.setCallback(() -> {
            NBTTagCompound sTag = stack.func_77978_p();
            if (sTag == null) {
                sTag = new NBTTagCompound();
                finStack.func_77982_d(sTag);
            }
            sTag.func_74782_a("barrelCap", (NBTBase)this.barrel.serializeNBT());
        });
        return this;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return BdsmCapabilies.CRATE_CAP == capability || capability == BdsmCapabilies.BARREL_CAP || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == BdsmCapabilies.CRATE_CAP) {
            return (T)BdsmCapabilies.CRATE_CAP.cast((Object)this.barrel);
        }
        if (capability == BdsmCapabilies.BARREL_CAP) {
            return (T)BdsmCapabilies.BARREL_CAP.cast((Object)this.barrel);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.barrel);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.barrel);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this.barrel);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = this.barrel.serializeNBT();
        if (this.stack != null) {
            this.stack.func_77983_a("barrelCap", (NBTBase)tag.func_74737_b());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.barrel.deserializeNBT(nbt);
        if (this.stack != null) {
            this.stack.func_77983_a("barrelCap", (NBTBase)nbt.func_74737_b());
        }
    }
}

