/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.items;

import funwayguy.bdsandm.blocks.tiles.TileEntityCrate;
import funwayguy.bdsandm.client.color.IBdsmColorItem;
import funwayguy.bdsandm.inventory.capability.BdsmCapabilies;
import funwayguy.bdsandm.inventory.capability.CapabilityProviderCrate;
import funwayguy.bdsandm.inventory.capability.ICrate;
import funwayguy.bdsandm.inventory.capability.IStackContainer;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrate
extends ItemBlock
implements IBdsmColorItem {
    private final int stackCap;
    private final int maxCap;
    private static final DecimalFormat df = new DecimalFormat("0.##");
    private static final String[] suffixes = new String[]{"", "K", "M", "B", "T"};

    public ItemCrate(Block block, int initCap, int maxCap) {
        super(block);
        this.stackCap = initCap;
        this.maxCap = maxCap;
    }

    @Override
    public int getColorCount(ItemStack stack) {
        if (!stack.hasCapability(BdsmCapabilies.CRATE_CAP, null)) {
            return 0;
        }
        return ((ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null)).getColorCount();
    }

    @Override
    public int[] getColors(ItemStack stack) {
        if (!stack.hasCapability(BdsmCapabilies.CRATE_CAP, null)) {
            return new int[0];
        }
        return ((ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null)).getColors();
    }

    @Override
    public void setColors(ItemStack stack, int[] color) {
        if (!stack.hasCapability(BdsmCapabilies.CRATE_CAP, null)) {
            return;
        }
        ((ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null)).setColors(color);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        CapabilityProviderCrate capProvCrate = new CapabilityProviderCrate(this.stackCap, this.maxCap).setParentStack(stack);
        if (nbt != null) {
            capProvCrate.deserializeNBT(nbt);
        }
        return capProvCrate;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ICrate crate = (ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null);
        assert (crate != null);
        if (!crate.getRefItem().func_190926_b()) {
            tooltip.add("Item: " + crate.getRefItem().func_82833_r());
            tooltip.add("Amount: " + ItemCrate.formatValue(crate.getCount()));
        } else {
            tooltip.add("[EMPTY]");
        }
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        ICrate crate = (ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null);
        assert (crate != null);
        stack.func_77983_a("crateCap", crate.serializeNBT());
        return super.getNBTShareTag(stack);
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        ICrate crate = (ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null);
        assert (crate != null);
        crate.deserializeNBT((NBTBase)stack.func_190925_c("crateCap"));
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrate && tile.hasCapability(BdsmCapabilies.CRATE_CAP, null)) {
            ((ICrate)tile.getCapability(BdsmCapabilies.CRATE_CAP, null)).copyContainer((IStackContainer)stack.getCapability(BdsmCapabilies.CRATE_CAP, null));
            ((TileEntityCrate)tile).onCrateChanged();
        }
        return true;
    }

    private static String formatValue(long value) {
        String s = "";
        double n = 1.0;
        for (int i = suffixes.length - 1; i >= 0; --i) {
            n = Math.pow(1000.0, i);
            if (!((double)Math.abs(value) >= n)) continue;
            s = suffixes[i];
            break;
        }
        return df.format((double)value / n) + s;
    }
}

