/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched;

import com.tattyseal.compactstorage.CompactStorage;
import com.tattyseal.compactstorage.item.ItemBlockChest;
import com.tattyseal.compactstorage.util.LogHelper;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.compatched.BlockBuilderExt;
import shadows.compatched.BlockChestExt;
import shadows.compatched.DummyLogger;
import shadows.compatched.ItemBackpackExt;
import shadows.compatched.TileBuilderExt;
import shadows.compatched.TileChestExt;

@Mod(modid="compatched", name="ComPatchedStorage", version="1.6.0", dependencies="required-after:compactstorage@[3.1,4.0)", acceptableRemoteVersions="[1.6.0,)", acceptedMinecraftVersions="[1.12.2]")
public class ComPatchedStorage {
    public static final String MODID = "compatched";
    public static final String MODNAME = "ComPatchedStorage";
    public static final String VERSION = "1.6.0";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) throws Exception {
        MinecraftForge.EVENT_BUS.register((Object)this);
        EnumHelper.setFailsafeFieldValue((Field)LogHelper.class.getField("logger"), null, (Object)new DummyLogger());
    }

    @SubscribeEvent
    public void caps(AttachCapabilitiesEvent<TileEntity> e) {
        TileEntity te = (TileEntity)e.getObject();
        if (te instanceof TileChestExt) {
            e.addCapability(new ResourceLocation(MODID, "invwrapper"), (ICapabilityProvider)new InvWrappingCap((IInventory)te));
        }
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        ModContainer us = Loader.instance().activeModContainer();
        Loader.instance().setActiveModContainer(Loader.instance().getModList().stream().filter(mc -> mc.getModId().equals("compactstorage")).findFirst().get());
        CompactStorage.ModBlocks.chest = new BlockChestExt();
        CompactStorage.ModBlocks.chestBuilder = new BlockBuilderExt();
        Loader.instance().setActiveModContainer(us);
        e.getRegistry().register((IForgeRegistryEntry)CompactStorage.ModBlocks.chest);
        e.getRegistry().register((IForgeRegistryEntry)CompactStorage.ModBlocks.chestBuilder);
        GameRegistry.registerTileEntity(TileChestExt.class, (ResourceLocation)new ResourceLocation("tileChest"));
        GameRegistry.registerTileEntity(TileBuilderExt.class, (ResourceLocation)new ResourceLocation("tileChestBuilder"));
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        CompactStorage.ModItems.backpack = (Item)new ItemBackpackExt().setRegistryName("compactstorage", "backpack");
        e.getRegistry().register((IForgeRegistryEntry)CompactStorage.ModItems.backpack);
        CompactStorage.ModItems.ibChest = new ItemBlockChest(CompactStorage.ModBlocks.chest){

            public String getCreatorModId(ItemStack itemStack) {
                return ComPatchedStorage.MODID;
            }
        };
        CompactStorage.ModItems.ibChest.setRegistryName("compactstorage", "compactChest");
        e.getRegistry().register((IForgeRegistryEntry)CompactStorage.ModItems.ibChest);
        Item ibChestBuilder = ((Item)new ItemBlock(CompactStorage.ModBlocks.chestBuilder){

            public String getCreatorModId(ItemStack itemStack) {
                return ComPatchedStorage.MODID;
            }
        }.setRegistryName("compactstorage", "chestBuilder")).func_77637_a(CompactStorage.tabCS);
        e.getRegistry().register((IForgeRegistryEntry)ibChestBuilder);
    }

    private static class InvWrappingCap
    implements ICapabilityProvider {
        InvWrapper wrapped;

        InvWrappingCap(IInventory toWrap) {
            this.wrapped = new InvWrapper(toWrap);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.wrapped);
            }
            return null;
        }
    }
}

