/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui;

import com.xcompwiz.mystcraft.client.gui.GuiContainerElements;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementButton;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementIcon;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementLabel;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementShopItem;
import com.xcompwiz.mystcraft.client.gui.element.data.GuiIconItemStack;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.ContainerVillagerShop;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiVillagerShop
extends GuiContainerElements
implements GuiElementButton.IGuiOnClickHandler,
GuiIconItemStack.IItemStackProvider {
    private ContainerVillagerShop container;

    public GuiVillagerShop(EntityPlayer player, EntityVillager entity) {
        super(new ContainerVillagerShop(player, entity));
        this.container = (ContainerVillagerShop)this.field_147002_h;
    }

    @Override
    public void validate() {
        this.field_146999_f = 176;
        this.field_147000_g = 181;
        int slotleft = 28;
        int padding = 3;
        int shop_slot_width = (this.field_146999_f - slotleft - padding - 3) / 3 - 1;
        int shop_slot_height = shop_slot_width * 3 / 2;
        int labelY = 10;
        int labelX = 40;
        ShopHandler shophandler = new ShopHandler();
        this.addElement(new GuiElementShopItem(shophandler, 0, slotleft, 4, shop_slot_width, shop_slot_height));
        this.addElement(new GuiElementShopItem(shophandler, 1, slotleft += shop_slot_width + padding, 4, shop_slot_width, shop_slot_height));
        this.addElement(new GuiElementShopItem(shophandler, 2, slotleft += shop_slot_width + padding, 4, shop_slot_width, shop_slot_height));
        this.addElement(new GuiElementIcon(new GuiIconItemStack(this, "booster"), 8, 9, 16, 16));
        GuiElementButton button = new GuiElementButton(this, "booster", 7, 27, 18, 18);
        button.setIcon(new GuiIconItemStack(this, "buybtnb"));
        button.setText("Buy");
        this.addElement(button);
        this.addElement(new GuiElementLabel(new EmeraldsHandler(), "emeralds", this.field_146999_f - 4 - labelX, 81, labelX, labelY, 0x44000000, -7798904));
        this.addElement(new GuiElementIcon(new GuiIconItemStack(new ItemStack(Items.field_151166_bC)), this.field_146999_f - 4 - labelX - labelY, 81, labelY, labelY));
    }

    @Override
    protected void _drawBackgroundLayer(int mouseX, int mouseY, float partial) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(Assets.GUIs.villagershop);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void onClick(GuiElementButton caller) {
        if (caller.getId().equals("booster")) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74757_a("PB", true);
            MystcraftPacketHandler.CHANNEL.sendToServer((IMessage)new MPacketGuiMessage(this.field_146297_k.field_71439_g.field_71070_bA.field_75152_c, nbttagcompound));
            this.container.processMessage((EntityPlayer)this.field_146297_k.field_71439_g, nbttagcompound);
        }
    }

    @Override
    @Nonnull
    public ItemStack getItemStack(GuiIconItemStack caller) {
        if (caller.getId().equals("booster")) {
            return new ItemStack(ModItems.booster, this.container.getBoosterCount());
        }
        if (caller.getId().equals("buybtnb")) {
            return new ItemStack(Items.field_151166_bC, this.container.getBoosterCost());
        }
        return ItemStack.field_190927_a;
    }

    public class ShopHandler
    implements GuiElementShopItem.IGuiShopHandler {
        @Override
        public void onPurchase(GuiElementShopItem caller) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("PI", caller.getId());
            MystcraftPacketHandler.CHANNEL.sendToServer((IMessage)new MPacketGuiMessage(GuiVillagerShop.this.field_146297_k.field_71439_g.field_71070_bA.field_75152_c, nbttagcompound));
            GuiVillagerShop.this.container.processMessage((EntityPlayer)GuiVillagerShop.this.field_146297_k.field_71439_g, nbttagcompound);
        }

        @Override
        public String getPriceText(GuiElementShopItem caller) {
            return Integer.toString(GuiVillagerShop.this.container.getShopItemPrice(caller.getId()));
        }

        @Override
        @Nonnull
        public ItemStack getItemstack(GuiElementShopItem caller) {
            return GuiVillagerShop.this.container.getShopItem(caller.getId());
        }
    }

    public class EmeraldsHandler
    implements GuiElementLabel.IGuiLabelDataProvider {
        @Override
        public String getText(GuiElementLabel caller) {
            return Integer.toString(GuiVillagerShop.this.container.getPlayerEmeralds());
        }

        @Override
        public List<String> getTooltip(GuiElementLabel caller) {
            return null;
        }
    }
}

