/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.inventory.IFluidTankProvider;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElementFluidTank
extends GuiElement {
    private List<String> hovertext = new ArrayList<String>();
    private boolean mouseOver;
    private IFluidTankProvider fluidprovider;

    public GuiElementFluidTank(IGuiMessageHandler handler, Minecraft mc, int left, int top, int width, int height, IFluidTankProvider fluidprovider) {
        super(left, top, width, height);
        this.mc = mc;
        this.fluidprovider = fluidprovider;
    }

    @Override
    public List<String> _getTooltipInfo() {
        if (this.hovertext != null && this.hovertext.size() > 0) {
            return this.hovertext;
        }
        return super._getTooltipInfo();
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        this.mouseOver = this.contains(mouseX, mouseY);
        FluidStack fluidstack = this.fluidprovider.getFluid();
        int tankmax = this.fluidprovider.getMax();
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
        mouseX -= guiLeft;
        mouseY -= guiTop;
        this.renderTank(fluidstack, 0, 0, this.xSize, this.ySize);
        this.hovertext.clear();
        if (this.mouseOver && fluidstack != null) {
            this.hovertext.add(fluidstack.getFluid().getLocalizedName(fluidstack) + ": " + fluidstack.amount + "/" + tankmax);
        }
        GlStateManager.func_179121_F();
    }

    private void renderTank(FluidStack fluidstack, int left, int top, int width, int height) {
        this.func_73733_a(left, top, left + width, top + height, -1728053248, -1728053248);
        this.func_73733_a(left + 1, top + 1, left + width - 1, top + height - 1, -3355410, -10066279);
        if (fluidstack == null) {
            return;
        }
        float filled = (float)fluidstack.amount / 1000.0f;
        if (filled > 1.0f) {
            filled = 1.0f;
        }
        int ltop = top + height - 1;
        int lheight = (int)((float)(height - 2) * filled);
        GuiUtils.drawFluid(this.mc.field_71446_o, fluidstack, left + 1, ltop - lheight, width - 2, lheight, this.getZLevel());
    }
}

