/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemRenameable;
import com.xcompwiz.mystcraft.api.item.IItemWritable;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.ModGUIs;
import com.xcompwiz.mystcraft.inventory.InventoryFolder;
import com.xcompwiz.mystcraft.item.IItemOnLoadable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFolder
extends Item
implements IItemRenameable,
IItemOrderablePageProvider,
IItemWritable,
IItemOnLoadable {
    public ItemFolder() {
        this.func_77625_d(1);
        this.func_77655_b("myst.folder");
        this.func_77637_a(MystcraftCommonProxy.tabMystCommon);
    }

    public int getItemStackLimit(ItemStack stack) {
        return InventoryFolder.isEmpty(stack) ? 32 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String name = InventoryFolder.getName(itemstack);
        if (name != null) {
            tooltip.add(name);
        }
    }

    public void func_77663_a(@Nonnull ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.initialize(worldIn, stack, entityIn);
    }

    public void func_77622_d(@Nonnull ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.initialize(worldIn, stack, (Entity)playerIn);
    }

    @Nonnull
    public EnumRarity func_77613_e(@Nonnull ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && held.func_190916_E() == 1) {
            playerIn.openGui((Object)Mystcraft.instance, ModGUIs.FOLDER.ordinal(), worldIn, MathHelper.func_76128_c((double)(playerIn.field_70165_t + 0.5)), MathHelper.func_76128_c((double)(playerIn.field_70163_u + 0.5)), MathHelper.func_76128_c((double)(playerIn.field_70161_v + 0.5)));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
    }

    private void initialize(World world, @Nonnull ItemStack itemstack, Entity entity) {
    }

    @Override
    @Nullable
    public String getDisplayName(EntityPlayer player, @Nonnull ItemStack itemstack) {
        return InventoryFolder.getName(itemstack);
    }

    @Override
    public void setDisplayName(EntityPlayer player, @Nonnull ItemStack itemstack, String name) {
        InventoryFolder.setName(itemstack, name);
    }

    @Override
    public boolean writeSymbol(EntityPlayer player, @Nonnull ItemStack itemstack, ResourceLocation symbol2) {
        return InventoryFolder.writeSymbol(itemstack, symbol2);
    }

    @Override
    @Nonnull
    public ItemStack removePage(EntityPlayer player, @Nonnull ItemStack folder, int index) {
        ItemStack itemstack = InventoryFolder.getItem(folder, index);
        InventoryFolder.removeItem(folder, index);
        return itemstack;
    }

    @Override
    public List<ItemStack> getPageList(EntityPlayer player, @Nonnull ItemStack folder) {
        return InventoryFolder.getItems(folder);
    }

    @Override
    @Nonnull
    public ItemStack setPage(EntityPlayer player, @Nonnull ItemStack folder, @Nonnull ItemStack page, int index) {
        return InventoryFolder.setItem(folder, index, page);
    }

    @Override
    @Nonnull
    public ItemStack addPage(EntityPlayer player, ItemStack folder, ItemStack page) {
        return InventoryFolder.addItem(folder, page);
    }

    @Override
    @Nonnull
    public ItemStack onLoad(@Nonnull ItemStack itemstack) {
        InventoryFolder.updatePages(itemstack);
        return itemstack;
    }
}

