/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SunsetRenderer {
    private float[] colorsSunriseSunset = new float[4];
    protected AgeDirector controller;
    protected ColorGradient gradient;

    public SunsetRenderer(AgeDirector controller, ColorGradient gradient) {
        this.controller = controller;
        this.gradient = gradient;
    }

    @SideOnly(value=Side.CLIENT)
    protected float[] getSunriseSunsetColors(float celestial_angle, float partialtick) {
        float f4;
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b((float)(celestial_angle * 3.141593f * 2.0f)) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * 3.141593f))) * 0.99f;
            f6 *= f6;
            ColorGradient gradient = this.gradient;
            Color color = null;
            if (gradient == null) {
                gradient = this.controller.getSunriseSunsetColor();
            }
            if (gradient != null && gradient.getColorCount() > 0) {
                color = gradient.getColor((float)this.controller.getTime() / 12000.0f);
            }
            if (color == null) {
                this.colorsSunriseSunset[0] = f5 * 0.3f + 0.7f;
                this.colorsSunriseSunset[1] = f5 * f5 * 0.7f + 0.2f;
                this.colorsSunriseSunset[2] = f5 * f5 * 0.0f + 0.2f;
            } else {
                this.colorsSunriseSunset[0] = color.r;
                this.colorsSunriseSunset[1] = color.g;
                this.colorsSunriseSunset[2] = color.b;
            }
            this.colorsSunriseSunset[3] = f6;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderHorizon(TextureManager eng, World worldObj, float celestial_period, float angle, float partial, float alpha) {
        float celestial_radians = celestial_period * (float)Math.PI * 2.0f;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        RenderHelper.func_74518_a();
        float[] horizoncolors = this.getSunriseSunsetColors(celestial_period, partial);
        if (horizoncolors != null) {
            float horizonRed = horizoncolors[0];
            float horizonGreen = horizoncolors[1];
            float horizonBlue = horizoncolors[2];
            horizoncolors[3] = horizoncolors[3] * alpha;
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                float red = (horizonRed * 30.0f + horizonGreen * 59.0f + horizonBlue * 11.0f) / 100.0f;
                float green = (horizonRed * 30.0f + horizonGreen * 70.0f) / 100.0f;
                float blue = (horizonRed * 30.0f + horizonBlue * 70.0f) / 100.0f;
                horizonRed = red;
                horizonGreen = green;
                horizonBlue = blue;
            }
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)celestial_radians) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            vb.func_181662_b(0.0, 100.0, 0.0).func_181666_a(horizonRed, horizonGreen, horizonBlue, horizoncolors[3]).func_181675_d();
            for (int l = 0; l <= 16; ++l) {
                float f21 = (float)l * ((float)Math.PI * 2) / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                vb.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * horizoncolors[3])).func_181666_a(horizonRed, horizonGreen, horizonBlue, 0.0f).func_181675_d();
            }
            tes.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
    }
}

